/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.components;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.sitemap.SitemapProvider;
import org.openhab.core.model.sitemap.sitemap.ButtonDefinition;
import org.openhab.core.model.sitemap.sitemap.ColorArray;
import org.openhab.core.model.sitemap.sitemap.IconRule;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Mapping;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.SitemapFactory;
import org.openhab.core.model.sitemap.sitemap.VisibilityRule;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.model.sitemap.sitemap.impl.ButtonDefinitionImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ButtonImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ButtongridImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ChartImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ColorArrayImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ColorpickerImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ColortemperaturepickerImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ConditionImpl;
import org.openhab.core.model.sitemap.sitemap.impl.DefaultImpl;
import org.openhab.core.model.sitemap.sitemap.impl.FrameImpl;
import org.openhab.core.model.sitemap.sitemap.impl.GroupImpl;
import org.openhab.core.model.sitemap.sitemap.impl.IconRuleImpl;
import org.openhab.core.model.sitemap.sitemap.impl.ImageImpl;
import org.openhab.core.model.sitemap.sitemap.impl.InputImpl;
import org.openhab.core.model.sitemap.sitemap.impl.MappingImpl;
import org.openhab.core.model.sitemap.sitemap.impl.MapviewImpl;
import org.openhab.core.model.sitemap.sitemap.impl.SelectionImpl;
import org.openhab.core.model.sitemap.sitemap.impl.SetpointImpl;
import org.openhab.core.model.sitemap.sitemap.impl.SitemapImpl;
import org.openhab.core.model.sitemap.sitemap.impl.SliderImpl;
import org.openhab.core.model.sitemap.sitemap.impl.SwitchImpl;
import org.openhab.core.model.sitemap.sitemap.impl.TextImpl;
import org.openhab.core.model.sitemap.sitemap.impl.VideoImpl;
import org.openhab.core.model.sitemap.sitemap.impl.VisibilityRuleImpl;
import org.openhab.core.model.sitemap.sitemap.impl.WebviewImpl;
import org.openhab.core.model.sitemap.sitemap.impl.WidgetImpl;
import org.openhab.core.ui.components.RootUIComponent;
import org.openhab.core.ui.components.UIComponent;
import org.openhab.core.ui.components.UIComponentRegistry;
import org.openhab.core.ui.components.UIComponentRegistryFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={SitemapProvider.class})
public class UIComponentSitemapProvider
implements SitemapProvider,
RegistryChangeListener<RootUIComponent> {
    private final Logger logger = LoggerFactory.getLogger(UIComponentSitemapProvider.class);
    public static final String SITEMAP_NAMESPACE = "system:sitemap";
    private static final String SITEMAP_PREFIX = "uicomponents_";
    private static final String SITEMAP_SUFFIX = ".sitemap";
    private static final Pattern CONDITION_PATTERN = Pattern.compile("((?<item>[A-Za-z]\\w*)?\\s*(?<condition>==|!=|<=|>=|<|>))?\\s*(?<sign>\\+|-)?(?<state>.+)");
    private static final Pattern COMMANDS_PATTERN = Pattern.compile("^(?<cmd1>\"[^\"]*\"|[^\": ]*):(?<cmd2>.*)$");
    private Map<String, Sitemap> sitemaps = new HashMap<String, Sitemap>();
    private @Nullable UIComponentRegistryFactory componentRegistryFactory;
    private @Nullable UIComponentRegistry sitemapComponentRegistry;
    private final Set<ModelRepositoryChangeListener> modelChangeListeners = new CopyOnWriteArraySet<ModelRepositoryChangeListener>();

    public @Nullable Sitemap getSitemap(String sitemapName) {
        this.buildSitemap(sitemapName.replaceFirst(SITEMAP_PREFIX, ""));
        return this.sitemaps.get(sitemapName);
    }

    public Set<String> getSitemapNames() {
        UIComponentRegistry registry = this.sitemapComponentRegistry;
        if (registry == null) {
            return Set.of();
        }
        this.sitemaps.clear();
        Collection rootComponents = registry.getAll();
        for (RootUIComponent rootComponent : rootComponents) {
            try {
                Sitemap sitemap = this.buildSitemap(rootComponent);
                this.sitemaps.put(sitemap.getName(), sitemap);
            }
            catch (Exception e) {
                this.logger.error("Cannot build sitemap {}", (Object)rootComponent.getUID(), (Object)e);
            }
        }
        return this.sitemaps.keySet();
    }

    protected @Nullable Sitemap buildSitemap(String sitemapName) {
        UIComponentRegistry registry = this.sitemapComponentRegistry;
        if (registry == null) {
            return null;
        }
        RootUIComponent rootComponent = (RootUIComponent)registry.get(sitemapName);
        if (rootComponent != null) {
            try {
                Sitemap sitemap = this.buildSitemap(rootComponent);
                this.sitemaps.put(sitemap.getName(), sitemap);
                return null;
            }
            catch (Exception e) {
                this.logger.error("Cannot build sitemap {}", (Object)rootComponent.getUID(), (Object)e);
            }
        }
        return null;
    }

    protected Sitemap buildSitemap(RootUIComponent rootComponent) {
        if (!"Sitemap".equals(rootComponent.getType())) {
            throw new IllegalArgumentException("Root component type is not Sitemap");
        }
        SitemapImpl sitemap = (SitemapImpl)SitemapFactory.eINSTANCE.createSitemap();
        sitemap.setName(SITEMAP_PREFIX + rootComponent.getUID());
        Object label = rootComponent.getConfig().get("label");
        if (label != null) {
            sitemap.setLabel(label.toString());
        }
        if (rootComponent.getSlots() != null && rootComponent.getSlots().containsKey("widgets")) {
            for (UIComponent component : rootComponent.getSlot("widgets")) {
                Widget widget = this.buildWidget(component);
                if (widget == null) continue;
                sitemap.getChildren().add((Object)widget);
            }
        }
        return sitemap;
    }

    /*
     * WARNING - void declaration
     */
    protected @Nullable Widget buildWidget(UIComponent component) {
        FrameImpl frameWidget;
        SliderImpl widget = null;
        switch (component.getType()) {
            case "Frame": {
                frameWidget = (FrameImpl)SitemapFactory.eINSTANCE.createFrame();
                widget = frameWidget;
                break;
            }
            case "Text": {
                TextImpl textWidget = (TextImpl)SitemapFactory.eINSTANCE.createText();
                widget = textWidget;
                break;
            }
            case "Group": {
                GroupImpl groupWidget = (GroupImpl)SitemapFactory.eINSTANCE.createGroup();
                widget = groupWidget;
                break;
            }
            case "Image": {
                ImageImpl imageWidget = (ImageImpl)SitemapFactory.eINSTANCE.createImage();
                widget = imageWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "url", 10);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "refresh", 11);
                break;
            }
            case "Video": {
                VideoImpl videoWidget = (VideoImpl)SitemapFactory.eINSTANCE.createVideo();
                widget = videoWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "url", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "encoding", 10);
                break;
            }
            case "Chart": {
                ChartImpl chartWidget = (ChartImpl)SitemapFactory.eINSTANCE.createChart();
                widget = chartWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "service", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "refresh", 10);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "period", 11);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "legend", 12);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "forceAsItem", 13);
                break;
            }
            case "Webview": {
                WebviewImpl webviewWidget = (WebviewImpl)SitemapFactory.eINSTANCE.createWebview();
                widget = webviewWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "height", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "url", 10);
                break;
            }
            case "Switch": {
                SwitchImpl switchWidget = (SwitchImpl)SitemapFactory.eINSTANCE.createSwitch();
                this.addWidgetMappings((EList<Mapping>)switchWidget.getMappings(), component);
                widget = switchWidget;
                break;
            }
            case "Mapview": {
                MapviewImpl mapviewWidget = (MapviewImpl)SitemapFactory.eINSTANCE.createMapview();
                widget = mapviewWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "height", 9);
                break;
            }
            case "Slider": {
                SliderImpl sliderWidget;
                widget = sliderWidget = (SliderImpl)SitemapFactory.eINSTANCE.createSlider();
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "minValue", 11);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "maxValue", 12);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "step", 13);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "switchEnabled", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "releaseOnly", 10);
                break;
            }
            case "Selection": {
                SelectionImpl selectionWidget = (SelectionImpl)SitemapFactory.eINSTANCE.createSelection();
                this.addWidgetMappings((EList<Mapping>)selectionWidget.getMappings(), component);
                widget = selectionWidget;
                break;
            }
            case "Input": {
                InputImpl inputWidget = (InputImpl)SitemapFactory.eINSTANCE.createInput();
                widget = inputWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "inputHint", 9);
                break;
            }
            case "Setpoint": {
                SetpointImpl setpointWidget = (SetpointImpl)SitemapFactory.eINSTANCE.createSetpoint();
                widget = setpointWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "minValue", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "maxValue", 10);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "step", 11);
                break;
            }
            case "Colorpicker": {
                ColorpickerImpl colorpickerWidget = (ColorpickerImpl)SitemapFactory.eINSTANCE.createColorpicker();
                widget = colorpickerWidget;
                break;
            }
            case "Colortemperaturepicker": {
                ColortemperaturepickerImpl colortemperaturepickerWidget = (ColortemperaturepickerImpl)SitemapFactory.eINSTANCE.createColortemperaturepicker();
                widget = colortemperaturepickerWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "minValue", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "maxValue", 10);
                break;
            }
            case "Buttongrid": {
                ButtongridImpl buttongridWidget = (ButtongridImpl)SitemapFactory.eINSTANCE.createButtongrid();
                this.addWidgetButtons((EList<ButtonDefinition>)buttongridWidget.getButtons(), component);
                widget = buttongridWidget;
                break;
            }
            case "Button": {
                ButtonImpl buttonWidget = (ButtonImpl)SitemapFactory.eINSTANCE.createButton();
                widget = buttonWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "row", 9);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "column", 10);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "stateless", 11);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "cmd", 12);
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "releaseCmd", 13);
                break;
            }
            case "Default": {
                DefaultImpl defaultWidget = (DefaultImpl)SitemapFactory.eINSTANCE.createDefault();
                widget = defaultWidget;
                this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "height", 9);
                break;
            }
            default: {
                this.logger.warn("Unknown sitemap component type {}", (Object)component.getType());
            }
        }
        if (widget != null) {
            this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "label", 1);
            this.setWidgetIconPropertyFromComponentConfig((Widget)widget, component);
            this.setWidgetPropertyFromComponentConfig((Widget)widget, component, "item", 0);
            SliderImpl sliderImpl = widget;
            if (sliderImpl instanceof LinkableWidget) {
                frameWidget = (LinkableWidget)sliderImpl;
                LinkableWidget cfr_ignored_0 = (LinkableWidget)sliderImpl;
                if (component.getSlots() != null && component.getSlots().containsKey("widgets")) {
                    for (UIComponent childComponent : component.getSlot("widgets")) {
                        void linkableWidget;
                        Widget childWidget = this.buildWidget(childComponent);
                        if (childWidget == null) continue;
                        linkableWidget.getChildren().add((Object)childWidget);
                    }
                }
            }
            this.addWidgetVisibility((EList<VisibilityRule>)widget.getVisibility(), component);
            this.addLabelColor((EList<ColorArray>)widget.getLabelColor(), component);
            this.addValueColor((EList<ColorArray>)widget.getValueColor(), component);
            this.addIconColor((EList<ColorArray>)widget.getIconColor(), component);
            this.addIconRules((EList<IconRule>)widget.getIconRules(), component);
        }
        return widget;
    }

    /*
     * WARNING - void declaration
     */
    private void setWidgetPropertyFromComponentConfig(Widget widget, @Nullable UIComponent component, String configParamName, int feature) {
        if (component == null || component.getConfig() == null) {
            return;
        }
        Object value = component.getConfig().get(configParamName);
        if (value == null) {
            return;
        }
        try {
            WidgetImpl widgetImpl = (WidgetImpl)widget;
            Object normalizedValue = ConfigUtil.normalizeType((Object)value);
            if (widgetImpl.eGet(feature, false, false) instanceof Integer) {
                int n;
                Object object = normalizedValue;
                if (object instanceof BigDecimal) {
                    void bd;
                    BigDecimal bigDecimal = (BigDecimal)object;
                    BigDecimal cfr_ignored_0 = (BigDecimal)object;
                    n = bd.intValue();
                } else {
                    n = Integer.parseInt(normalizedValue.toString());
                }
                normalizedValue = n;
            } else if (widgetImpl.eGet(feature, false, false) instanceof Boolean && !(normalizedValue instanceof Boolean)) {
                normalizedValue = Boolean.valueOf(normalizedValue.toString());
            }
            widgetImpl.eSet(feature, normalizedValue);
        }
        catch (Exception e) {
            this.logger.warn("Cannot set {} parameter for {} widget parameter: {}", new Object[]{configParamName, component.getType(), e.getMessage()});
        }
    }

    private void setWidgetIconPropertyFromComponentConfig(Widget widget, @Nullable UIComponent component) {
        if (component == null || component.getConfig() == null) {
            return;
        }
        Object staticIcon = component.getConfig().get("staticIcon");
        if (staticIcon != null && Boolean.parseBoolean(ConfigUtil.normalizeType((Object)staticIcon).toString())) {
            this.setWidgetPropertyFromComponentConfig(widget, component, "icon", 4);
            return;
        }
        Object icon = component.getConfig().get("icon");
        if (icon == null) {
            return;
        }
        this.setWidgetPropertyFromComponentConfig(widget, component, "icon", 2);
    }

    private @Nullable String stripQuotes(@Nullable String input) {
        if (input != null && input.length() >= 2 && input.charAt(0) == '\"' && input.charAt(input.length() - 1) == '\"') {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private void addWidgetMappings(EList<Mapping> mappings, UIComponent component) {
        Object sourceMappings;
        Object object;
        if (component.getConfig() != null && component.getConfig().containsKey("mappings") && (object = (sourceMappings = component.getConfig().get("mappings"))) instanceof Collection) {
            void sourceMappingsCollection;
            Collection collection = (Collection)object;
            Collection cfr_ignored_0 = (Collection)object;
            for (Object sourceMapping : sourceMappingsCollection) {
                if (!(sourceMapping instanceof String)) continue;
                String[] splitMapping = sourceMapping.toString().split("=");
                String cmd = splitMapping[0].trim();
                String releaseCmd = null;
                Matcher matcher = COMMANDS_PATTERN.matcher(cmd);
                if (matcher.matches()) {
                    cmd = matcher.group("cmd1");
                    releaseCmd = matcher.group("cmd2");
                }
                cmd = this.stripQuotes(cmd);
                releaseCmd = this.stripQuotes(releaseCmd);
                String label = this.stripQuotes(splitMapping[1].trim());
                String icon = splitMapping.length < 3 ? null : this.stripQuotes(splitMapping[2].trim());
                MappingImpl mapping = (MappingImpl)SitemapFactory.eINSTANCE.createMapping();
                mapping.setCmd(cmd);
                mapping.setReleaseCmd(releaseCmd);
                mapping.setLabel(label);
                mapping.setIcon(icon);
                mappings.add((Object)mapping);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addWidgetButtons(EList<ButtonDefinition> buttons, UIComponent component) {
        Object sourceButtons;
        Object object;
        if (component.getConfig() != null && component.getConfig().containsKey("buttons") && (object = (sourceButtons = component.getConfig().get("buttons"))) instanceof Collection) {
            void sourceButtonsCollection;
            Collection collection = (Collection)object;
            Collection cfr_ignored_0 = (Collection)object;
            for (Object sourceButton : sourceButtonsCollection) {
                if (!(sourceButton instanceof String)) continue;
                String[] splitted1 = sourceButton.toString().split(":", 3);
                int row = Integer.parseInt(splitted1[0].trim());
                int column = Integer.parseInt(splitted1[1].trim());
                String[] splitted2 = splitted1[2].trim().split("=");
                String cmd = this.stripQuotes(splitted2[0].trim());
                String label = this.stripQuotes(splitted2[1].trim());
                String icon = splitted2.length < 3 ? null : this.stripQuotes(splitted2[2].trim());
                ButtonDefinitionImpl button = (ButtonDefinitionImpl)SitemapFactory.eINSTANCE.createButtonDefinition();
                button.setRow(row);
                button.setColumn(column);
                button.setCmd(cmd);
                button.setLabel(label);
                button.setIcon(icon);
                buttons.add((Object)button);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addWidgetVisibility(EList<VisibilityRule> visibility, UIComponent component) {
        Object sourceVisibilities;
        Object object;
        if (component.getConfig() != null && component.getConfig().containsKey("visibility") && (object = (sourceVisibilities = component.getConfig().get("visibility"))) instanceof Collection) {
            void sourceVisibilitiesCollection;
            Collection collection = (Collection)object;
            Collection cfr_ignored_0 = (Collection)object;
            for (Object sourceVisibility : sourceVisibilitiesCollection) {
                if (!(sourceVisibility instanceof String)) continue;
                List<String> conditionsString = this.getRuleConditions(sourceVisibility.toString(), null);
                VisibilityRuleImpl visibilityRule = (VisibilityRuleImpl)SitemapFactory.eINSTANCE.createVisibilityRule();
                List<ConditionImpl> conditions = this.getConditions(conditionsString, component, "visibility");
                visibilityRule.eSet(0, conditions);
                visibility.add((Object)visibilityRule);
            }
        }
    }

    private void addLabelColor(EList<ColorArray> labelColor, UIComponent component) {
        this.addColor(labelColor, component, "labelcolor");
    }

    private void addValueColor(EList<ColorArray> valueColor, UIComponent component) {
        this.addColor(valueColor, component, "valuecolor");
    }

    private void addIconColor(EList<ColorArray> iconColor, UIComponent component) {
        this.addColor(iconColor, component, "iconcolor");
    }

    /*
     * WARNING - void declaration
     */
    private void addColor(EList<ColorArray> color, UIComponent component, String key) {
        Object sourceColors;
        Object object;
        if (component.getConfig() != null && component.getConfig().containsKey(key) && (object = (sourceColors = component.getConfig().get(key))) instanceof Collection) {
            void sourceColorsCollection;
            Collection collection = (Collection)object;
            Collection cfr_ignored_0 = (Collection)object;
            for (Object sourceColor : sourceColorsCollection) {
                if (!(sourceColor instanceof String)) continue;
                String argument = this.getRuleArgument(sourceColor.toString());
                List<String> conditionsString = this.getRuleConditions(sourceColor.toString(), argument);
                ColorArrayImpl colorArray = (ColorArrayImpl)SitemapFactory.eINSTANCE.createColorArray();
                colorArray.setArg(argument);
                List<ConditionImpl> conditions = this.getConditions(conditionsString, component, key);
                colorArray.eSet(0, conditions);
                color.add((Object)colorArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addIconRules(EList<IconRule> icon, UIComponent component) {
        Object sourceIcons;
        Object object;
        if (component.getConfig() != null && component.getConfig().containsKey("iconrules") && (object = (sourceIcons = component.getConfig().get("iconrules"))) instanceof Collection) {
            void sourceIconsCollection;
            Collection collection = (Collection)object;
            Collection cfr_ignored_0 = (Collection)object;
            for (Object sourceIcon : sourceIconsCollection) {
                if (!(sourceIcon instanceof String)) continue;
                String argument = this.getRuleArgument(sourceIcon.toString());
                List<String> conditionsString = this.getRuleConditions(sourceIcon.toString(), argument);
                IconRuleImpl iconRule = (IconRuleImpl)SitemapFactory.eINSTANCE.createIconRule();
                iconRule.setArg(argument);
                List<ConditionImpl> conditions = this.getConditions(conditionsString, component, "iconrules");
                iconRule.eSet(0, conditions);
                icon.add((Object)iconRule);
            }
        }
    }

    private List<ConditionImpl> getConditions(List<String> conditionsString, UIComponent component, String key) {
        ArrayList<ConditionImpl> conditions = new ArrayList<ConditionImpl>();
        for (String conditionString : conditionsString) {
            Matcher matcher = CONDITION_PATTERN.matcher(conditionString);
            if (matcher.matches()) {
                ConditionImpl condition = (ConditionImpl)SitemapFactory.eINSTANCE.createCondition();
                condition.setItem(matcher.group("item"));
                condition.setCondition(matcher.group("condition"));
                condition.setSign(matcher.group("sign"));
                condition.setState(this.stripQuotes(matcher.group("state")));
                conditions.add(condition);
                continue;
            }
            this.logger.warn("Syntax error in {} rule condition '{}' for widget {}", new Object[]{key, conditionString, component.getType()});
        }
        return conditions;
    }

    private String getRuleArgument(String rule) {
        int argIndex = rule.lastIndexOf("=") + 1;
        String strippedRule = this.stripQuotes(rule.substring(argIndex).trim());
        return strippedRule != null ? strippedRule : "";
    }

    private List<String> getRuleConditions(String rule, @Nullable String argument) {
        String conditions = rule;
        if (argument != null && (conditions = rule.substring(0, rule.lastIndexOf(argument)).trim()).endsWith("=")) {
            conditions = conditions.substring(0, conditions.length() - 1);
        }
        List<String> conditionsList = List.of(conditions.split(" AND "));
        return conditionsList.stream().filter(Predicate.not(String::isBlank)).map(String::trim).toList();
    }

    public void addModelChangeListener(ModelRepositoryChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(ModelRepositoryChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    public void added(RootUIComponent element) {
        for (ModelRepositoryChangeListener listener : this.modelChangeListeners) {
            listener.modelChanged(SITEMAP_PREFIX + element.getUID() + SITEMAP_SUFFIX, EventType.ADDED);
        }
    }

    public void removed(RootUIComponent element) {
        for (ModelRepositoryChangeListener listener : this.modelChangeListeners) {
            listener.modelChanged(SITEMAP_PREFIX + element.getUID() + SITEMAP_SUFFIX, EventType.REMOVED);
        }
    }

    public void updated(RootUIComponent oldElement, RootUIComponent element) {
        for (ModelRepositoryChangeListener listener : this.modelChangeListeners) {
            listener.modelChanged(SITEMAP_PREFIX + element.getUID() + SITEMAP_SUFFIX, EventType.MODIFIED);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setComponentRegistryFactory(UIComponentRegistryFactory componentRegistryFactory) {
        this.componentRegistryFactory = componentRegistryFactory;
        this.sitemapComponentRegistry = this.componentRegistryFactory.getRegistry(SITEMAP_NAMESPACE);
        this.sitemapComponentRegistry.addRegistryChangeListener(this);
    }

    protected void unsetComponentRegistryFactory(UIComponentRegistryFactory componentRegistryFactory) {
        UIComponentRegistry registry = this.sitemapComponentRegistry;
        if (registry != null) {
            registry.removeRegistryChangeListener(this);
        }
        this.componentRegistryFactory = null;
        this.sitemapComponentRegistry = null;
    }
}

