/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.rule.scoping;

import java.util.HashMap;
import org.eclipse.xtext.common.types.access.impl.Primitives;
import org.openhab.core.model.script.engine.action.ActionService;
import org.openhab.core.thing.binding.ThingActions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RulesClassCache
extends HashMap<String, Class<?>> {
    private static final long serialVersionUID = 1L;
    private static RulesClassCache instance;
    private final Logger logger = LoggerFactory.getLogger(RulesClassCache.class);

    @Activate
    public RulesClassCache() {
        super(500);
        for (Class primitiveType : Primitives.ALL_PRIMITIVE_TYPES) {
            this.put(primitiveType.getName(), primitiveType);
        }
        if (instance != null) {
            throw new IllegalStateException("RulesClassCache should only be activated once!");
        }
        instance = this;
    }

    @Deactivate
    public void deactivate() {
        this.clear();
        instance = null;
    }

    public static RulesClassCache getInstance() {
        return instance;
    }

    private void updateCacheEntry(Object object) {
        String key = object.getClass().getName();
        this.put(key, object.getClass());
        this.logger.debug("Updated cache entry: {}", (Object)key);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addActionService(ActionService actionService) {
        this.updateCacheEntry(actionService);
    }

    public void removeActionService(ActionService actionService) {
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addThingActions(ThingActions thingActions) {
        this.updateCacheEntry(thingActions);
    }

    public void removeThingActions(ThingActions thingActions) {
    }
}

