/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * floor(-2.0) => -2.0
 * floor(-0.6666667) => -1.0
 * floor(0.6666667) => 0.0
 * floor(2.0) => 2.0
 */
#version 150

void main()
{
  float[distance(floor(-2.0), -2.0) <= 2e-05 ? 1 : -1] array0;
  float[distance(floor(-0.6666667), -1.0) <= 1e-05 ? 1 : -1] array1;
  float[distance(floor(0.6666667), 0.0) <= 0.0 ? 1 : -1] array2;
  float[distance(floor(2.0), 2.0) <= 2e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
