/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import io.grpc.CallCredentials;
import io.grpc.alts.AltsContextUtil;
import java.util.concurrent.Executor;

final class DualCallCredentials
extends CallCredentials {
    private final CallCredentials tlsCallCredentials;
    private final CallCredentials altsCallCredentials;

    public DualCallCredentials(CallCredentials tlsCallCreds, CallCredentials altsCallCreds) {
        this.tlsCallCredentials = tlsCallCreds;
        this.altsCallCredentials = altsCallCreds;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (AltsContextUtil.check(requestInfo.getTransportAttrs())) {
            this.altsCallCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
        } else {
            this.tlsCallCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
        }
    }
}

