/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;
import org.openhab.core.automation.internal.commands.Printer;
import org.openhab.core.automation.internal.commands.Utils;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.Template;
import org.openhab.core.automation.type.ModuleType;

public class AutomationCommandList
extends AutomationCommand {
    private String id;
    private Locale locale;

    public AutomationCommandList(String command, String[] params, int adminType, AutomationCommandsPluggable autoCommands) {
        super(command, params, adminType, autoCommands);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    @Override
    public String execute() {
        if (!this.parsingResult.equals("SUCCESS")) {
            return this.parsingResult;
        }
        if (this.providerType == 3) {
            return this.listModuleTypes();
        }
        if (this.providerType == 2) {
            return this.listTemplates();
        }
        if (this.providerType == 1) {
            return this.listRules();
        }
        return "FAIL";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getId = true;
        boolean getLocale = true;
        String[] stringArray = parameterValues;
        int n = parameterValues.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterValue = stringArray[n2];
            if (parameterValue != null) {
                if (parameterValue.charAt(0) == '-') {
                    if (!"-st".equals(parameterValue)) return String.format("Unsupported option: %s", parameterValue);
                    this.st = true;
                } else if (getId) {
                    this.id = parameterValue;
                    getId = false;
                } else {
                    if (getLocale) {
                        String l = parameterValue;
                        this.locale = new Locale(l);
                        getLocale = false;
                    }
                    if (getId && getLocale) {
                        return String.format("Unsupported parameter: %s", parameterValue);
                    }
                }
            }
            ++n2;
        }
        return "SUCCESS";
    }

    private String listRules() {
        Collection<Rule> collection = this.autoCommands.getRules();
        Hashtable rules = new Hashtable();
        Map<String, String> listRules = null;
        if (collection != null && !collection.isEmpty()) {
            this.addCollection(collection, rules);
            String[] uids = new String[rules.size()];
            Utils.quickSort(rules.keySet().toArray(uids), 0, rules.size());
            listRules = Utils.putInHastable(uids);
        }
        if (listRules != null && !listRules.isEmpty()) {
            if (this.id != null) {
                collection = this.getRuleByFilter(listRules);
                if (collection.size() == 1) {
                    Rule r = (Rule)collection.toArray()[0];
                    if (r != null) {
                        RuleStatus status = this.autoCommands.getRuleStatus(r.getUID());
                        return Printer.printRule(r, status);
                    }
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (collection.isEmpty()) {
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (!rules.isEmpty()) {
                    rules.clear();
                }
                this.addCollection(collection, rules);
                listRules = Utils.filterList(rules, listRules);
            }
            return Printer.printRules(this.autoCommands, listRules);
        }
        return "There are no Rules available!";
    }

    private String listTemplates() {
        Collection<RuleTemplate> collection = this.autoCommands.getTemplates(this.locale);
        Hashtable templates = new Hashtable();
        Map<String, String> listTemplates = null;
        if (collection != null && !collection.isEmpty()) {
            this.addCollection(collection, templates);
            String[] uids = new String[templates.size()];
            Utils.quickSort(templates.keySet().toArray(uids), 0, templates.size());
            listTemplates = Utils.putInHastable(uids);
        }
        if (listTemplates != null && !listTemplates.isEmpty()) {
            if (this.id != null) {
                collection = this.getTemplateByFilter(listTemplates);
                if (collection.size() == 1) {
                    Template t = (Template)collection.toArray()[0];
                    if (t != null) {
                        return Printer.printTemplate(t);
                    }
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (collection.isEmpty()) {
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (!templates.isEmpty()) {
                    templates.clear();
                }
                this.addCollection(collection, templates);
                listTemplates = Utils.filterList(templates, listTemplates);
            }
            if (listTemplates != null && !listTemplates.isEmpty()) {
                return Printer.printTemplates(listTemplates);
            }
        }
        return "There are no Templates available!";
    }

    private String listModuleTypes() {
        Hashtable moduleTypes = new Hashtable();
        Collection<ModuleType> collection = this.autoCommands.getTriggers(this.locale);
        this.addCollection(collection, moduleTypes);
        collection = this.autoCommands.getConditions(this.locale);
        this.addCollection(collection, moduleTypes);
        collection = this.autoCommands.getActions(this.locale);
        this.addCollection(collection, moduleTypes);
        Map<String, String> listModuleTypes = null;
        if (!moduleTypes.isEmpty()) {
            String[] uids = new String[moduleTypes.size()];
            Utils.quickSort(moduleTypes.keySet().toArray(uids), 0, moduleTypes.size());
            listModuleTypes = Utils.putInHastable(uids);
        }
        if (listModuleTypes != null && !listModuleTypes.isEmpty()) {
            if (this.id != null) {
                collection = this.getModuleTypeByFilter(listModuleTypes);
                if (collection.size() == 1) {
                    ModuleType mt = (ModuleType)collection.toArray()[0];
                    if (mt != null) {
                        return Printer.printModuleType(mt);
                    }
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (collection.isEmpty()) {
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (!moduleTypes.isEmpty()) {
                    moduleTypes.clear();
                }
                this.addCollection(collection, moduleTypes);
                listModuleTypes = Utils.filterList(moduleTypes, listModuleTypes);
            }
            return Printer.printModuleTypes(listModuleTypes);
        }
        return "There are no Module Types available!";
    }

    private Collection<Rule> getRuleByFilter(Map<String, String> list) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (!list.isEmpty()) {
            String uid = list.get(this.id);
            if (uid != null) {
                Rule r = this.autoCommands.getRule(uid);
                if (r != null) {
                    rules.add(r);
                    return rules;
                }
            } else {
                Rule r = this.autoCommands.getRule(this.id);
                if (r != null) {
                    rules.add(r);
                    return rules;
                }
                for (String ruleUID : list.values()) {
                    if (!ruleUID.contains(this.id)) continue;
                    rules.add(this.autoCommands.getRule(ruleUID));
                }
            }
        }
        return rules;
    }

    private Collection<RuleTemplate> getTemplateByFilter(Map<String, String> list) {
        ArrayList<RuleTemplate> templates = new ArrayList<RuleTemplate>();
        String uid = list.get(this.id);
        if (uid != null) {
            RuleTemplate t = this.autoCommands.getTemplate(uid, this.locale);
            if (t != null) {
                templates.add(t);
                return templates;
            }
        } else {
            RuleTemplate t = this.autoCommands.getTemplate(this.id, this.locale);
            if (t != null) {
                templates.add(t);
                return templates;
            }
            for (String templateUID : list.keySet()) {
                if (!templateUID.contains(this.id)) continue;
                templates.add(this.autoCommands.getTemplate(templateUID, this.locale));
            }
        }
        return templates;
    }

    private Collection<ModuleType> getModuleTypeByFilter(Map<String, String> list) {
        ArrayList<ModuleType> moduleTypes = new ArrayList<ModuleType>();
        if (!list.isEmpty()) {
            String uid = list.get(this.id);
            if (uid != null) {
                ModuleType mt = this.autoCommands.getModuleType(uid, this.locale);
                if (mt != null) {
                    moduleTypes.add(mt);
                    return moduleTypes;
                }
            } else {
                ModuleType mt = this.autoCommands.getModuleType(this.id, this.locale);
                if (mt != null) {
                    moduleTypes.add(mt);
                    return moduleTypes;
                }
                for (String typeUID : list.values()) {
                    if (!typeUID.contains(this.id)) continue;
                    moduleTypes.add(this.autoCommands.getModuleType(typeUID, this.locale));
                }
            }
        }
        return moduleTypes;
    }

    /*
     * WARNING - void declaration
     */
    private void addCollection(Collection collection, Map list) {
        if (collection != null && !collection.isEmpty()) {
            for (Object element : collection) {
                void rule;
                Object e;
                Object e2;
                Object e3 = element;
                if (e3 instanceof ModuleType) {
                    void type;
                    ModuleType cfr_ignored_0 = (ModuleType)e3;
                    ModuleType cfr_ignored_1 = (ModuleType)e3;
                    list.put(type.getUID(), element);
                }
                if ((e2 = element) instanceof RuleTemplate) {
                    void template;
                    RuleTemplate cfr_ignored_2 = (RuleTemplate)e2;
                    RuleTemplate cfr_ignored_3 = (RuleTemplate)e2;
                    list.put(template.getUID(), element);
                }
                if (!((e = element) instanceof Rule)) continue;
                Rule cfr_ignored_4 = (Rule)e;
                Rule cfr_ignored_5 = (Rule)e;
                list.put(rule.getUID(), element);
            }
        }
    }
}

