/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.felix.metatype.AD;

final class ADValidator {
    ADValidator() {
    }

    public static String validate(AD ad, String rawInput) {
        if (rawInput == null) {
            if (ad.isRequired()) {
                return "%missing required value";
            }
            return "";
        }
        String[] input = ad.getCardinality() == 0 ? new String[]{rawInput.trim()} : AD.splitList(rawInput);
        int type = ad.getType();
        switch (type) {
            case 11: {
                return ADValidator.validateBooleanValue(ad, input);
            }
            case 5: {
                return ADValidator.validateCharacterValue(ad, input);
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return ADValidator.validateNumericValue(ad, input);
            }
            case 1: 
            case 12: {
                return ADValidator.validateString(ad, input);
            }
        }
        return null;
    }

    private static String findOptionValue(String searchValue, String[] optionValues) {
        if (searchValue == null || optionValues == null || optionValues.length == 0) {
            return "";
        }
        for (int i = 0; i < optionValues.length; ++i) {
            if (!optionValues[i].equals(searchValue)) continue;
            return optionValues[i];
        }
        return null;
    }

    private static Comparable parseNumber(int type, String value) throws NumberFormatException {
        if (value != null && value.length() > 0) {
            switch (type) {
                case 10: {
                    return new BigDecimal(value);
                }
                case 9: {
                    return new BigInteger(value);
                }
                case 6: {
                    return Byte.valueOf(value);
                }
                case 4: {
                    return Short.valueOf(value);
                }
                case 3: {
                    return Integer.valueOf(value);
                }
                case 2: {
                    return Long.valueOf(value);
                }
                case 8: {
                    return Float.valueOf(value);
                }
                case 7: {
                    return Double.valueOf(value);
                }
            }
            return null;
        }
        return null;
    }

    private static Character parseOptionalChar(String value) {
        if (value != null && value.length() > 0) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    private static Comparable parseOptionalNumber(int type, String value) {
        if (value != null) {
            try {
                return ADValidator.parseNumber(type, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String validateBooleanValue(AD ad, String[] input) {
        for (int i = 0; i < input.length; ++i) {
            int length;
            String value = input[i];
            int n = length = value == null ? 0 : value.length();
            if (length == 0 && ad.isRequired()) {
                return "%missing required value";
            }
            if (length <= 0 || "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue;
            return "%invalid value";
        }
        String[] optionValues = ad.getOptionValues();
        if (optionValues != null && optionValues.length > 0) {
            return null;
        }
        return "";
    }

    private static String validateCharacterValue(AD ad, String[] input) {
        Character min = ADValidator.parseOptionalChar(ad.getMin());
        Character max = ADValidator.parseOptionalChar(ad.getMax());
        String[] optionValues = ad.getOptionValues();
        for (int i = 0; i < input.length; ++i) {
            int length;
            Character ch = null;
            int n = length = input[i] == null ? 0 : input[i].length();
            if (length > 1) {
                return "%greater than maximum";
            }
            if (length == 0 && ad.isRequired()) {
                return "%missing required value";
            }
            if (length == 1) {
                ch = Character.valueOf(input[i].charAt(0));
                if (min != null && ch.compareTo(min) < 0) {
                    return "%less than minimum";
                }
                if (max != null && ch.compareTo(max) > 0) {
                    return "%greater than maximum";
                }
            }
            if (ADValidator.findOptionValue(input[i], optionValues) != null) continue;
            return "%not a valid option";
        }
        return "";
    }

    private static String validateNumericValue(AD ad, String[] input) {
        Comparable min = ADValidator.parseOptionalNumber(ad.getType(), ad.getMin());
        Comparable max = ADValidator.parseOptionalNumber(ad.getType(), ad.getMax());
        String[] optionValues = ad.getOptionValues();
        for (int i = 0; i < input.length; ++i) {
            Comparable value = null;
            try {
                value = ADValidator.parseNumber(ad.getType(), input[i]);
            }
            catch (NumberFormatException e) {
                return "%invalid value";
            }
            if (value == null && ad.isRequired()) {
                return "%missing required value";
            }
            if (min != null && value != null && value.compareTo(min) < 0) {
                return "%less than minimum";
            }
            if (max != null && value != null && value.compareTo(max) > 0) {
                return "%greater than maximum";
            }
            if (ADValidator.findOptionValue(input[i], optionValues) != null) continue;
            return "%not a valid option";
        }
        return "";
    }

    private static String validateString(AD ad, String[] input) {
        Integer min = (Integer)ADValidator.parseOptionalNumber(3, ad.getMin());
        Integer max = (Integer)ADValidator.parseOptionalNumber(3, ad.getMax());
        String[] optionValues = ad.getOptionValues();
        for (int i = 0; i < input.length; ++i) {
            int length;
            String value = input[i];
            int n = length = value == null ? 0 : value.length();
            if (ad.isRequired() && value == null) {
                return "%missing required value";
            }
            if (min != null && length < min) {
                return "%less than minimum";
            }
            if (max != null && length > max) {
                return "%greater than maximum";
            }
            if (ADValidator.findOptionValue(value, optionValues) != null) continue;
            return "%not a valid option";
        }
        return "";
    }
}

