/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.anonymous;

import java.io.Serializable;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AbstractAuthenticationToken;

public class AnonymousAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object principal;
    private int keyHash;

    public AnonymousAuthenticationToken(String key, Object principal, GrantedAuthority[] authorities) {
        super(authorities);
        if (key == null || "".equals(key) || principal == null || "".equals(principal) || authorities == null || authorities.length == 0) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.setAuthenticated(true);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AnonymousAuthenticationToken) {
            AnonymousAuthenticationToken test = (AnonymousAuthenticationToken)obj;
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public Object getCredentials() {
        return "";
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }
}

