/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2009-08-03
 * Description : digiKam config header
 *
 * SPDX-FileCopyrightText: 2009-2025 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#pragma once

/* Define to 1 if you have KDEPIM shared library installed */
/* #undef HAVE_AKONADICONTACT */

/* Define to 1 if an external lensfun shared library have been found */
#define HAVE_LENSFUN 1

/* Define to 1 if an external KIO shared library have been found */
#define HAVE_KIO 1

/* Define to 1 if an external Sonnet shared library have been found */
#define HAVE_SONNET 1

/* Define to 1 if an external Ksane shared library have been found */
#define HAVE_KSANE 1

/* Define to 1 if an external Marble shared library have been found */
#define HAVE_GEOLOCATION 1

/* Define to 1 if an external Eigen3 shared library have been found */
#define HAVE_EIGEN3 1

/* Define to 1 if an external x265 shared library have been found */
#define HAVE_X265 1

/* Define to 1 if an external Heif shared library have been found */
#define HAVE_HEIF 1

/* The Eigen3 version string, if found, or an empty string otherwise */
#define EIGEN3_VERSION_STRING "3.4.0"

/* Define to 1 if GPhoto2 shared library is installed */
#define HAVE_GPHOTO2 1

/* Define to 1 if Jasper shared library is installed */
#define HAVE_JASPER 1

/* Define to 1 if libjxl shared library is installed */
#define HAVE_JXL 1

/* Define to 1 if libgphoto2 2.5 shared library is installed */
#define HAVE_GPHOTO25 1

/* Define to 1 if you have Baloo shared libraries installed */
#define HAVE_KFILEMETADATA 1

/* Define to 1 if you have KIconThemes shared libraries installed */
#define HAVE_KICONTHEMES 1

/* Define to 1 if you have KNotifications shared libraries installed */
#define HAVE_KNOTIFICATIONS 1

/* Define to 1 if you have KNotifyConfig shared libraries installed */
#define HAVE_KNOTIFYCONFIG 1

/* Define to 1 if you have KCalendar core shared libraries installed */
#define HAVE_KCALENDAR 1

/* Define to 1 if you have KCalendar core shared libraries with QDateTime support installed */
#define HAVE_KCALENDAR_QDATETIME 1

/* Define to 1 if Panorama tool is supported */
#define HAVE_PANORAMA 1

/* Define to 1 if HTMLGallery tool is supported */
#define HAVE_HTMLGALLERY 1

/* Define to 1 if we support mysql database */
/* #undef HAVE_MYSQLSUPPORT */

/* Define to 1 if we support mysql internal database server */
/* #undef HAVE_INTERNALMYSQL */

/* Define to 1 if preview of video files is supported */
#define HAVE_MEDIAPLAYER 1

/* Define to 1 if DBUS is supported */
#define HAVE_DBUS 1

/* Define to 1 if system use OpenGL */
#define HAVE_OPENGL 1

/* Define to 1 if system use X11 */
#define HAVE_X11 1

/* Define to 1 if changing application styles is supported */
/* #undef HAVE_APPSTYLE_SUPPORT */

/* Define to 1 if system use QtMultimedia */
#define HAVE_QTMULTIMEDIA 1

/* Define to 1 if system use QtXmlPatterns */
/* #undef HAVE_QTXMLPATTERNS */

/* Define to 1 if ImageMagick codecs are supported */
#define HAVE_IMAGE_MAGICK 1

#define LIBEXEC_INSTALL_DIR "/usr/local/libexec"

#define CMAKE_VERSION_STRING        "4.2.3"
#define CMAKE_CXX_COMPILER_ID       "Clang"
#define CMAKE_CXX_COMPILER_VERSION  "19.1.7"
#define CMAKE_HOST_PRETTY_NAME      ""
#define CMAKE_SYSTEM_PROCESSOR      "aarch64"
#define CMAKE_HOST_SYSTEM_PROCESSOR "aarch64"
