/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavacNameTable {
    private final Elements myElements;
    private Name myAsterisk;
    private Name myInit;
    private TypeElement myStreamElement;
    private TypeElement myIteratorElement;
    private TypeElement myIterableElement;
    private TypeElement myStringElement;
    private final Map<Name, String> myParsedNameCache = new LinkedHashMap<Name, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Name, String> eldest) {
            return this.size() > 5000;
        }
    };

    public JavacNameTable(Elements elements) {
        this.myElements = elements;
    }

    @NotNull
    public String parseName(Name name) {
        String value = this.myParsedNameCache.get(name);
        if (value == null) {
            value = name.toString();
            this.myParsedNameCache.put(name, value);
        }
        String string = value;
        if (string == null) {
            JavacNameTable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String parseBinaryName(Element element) {
        String string = this.parseName(this.myElements.getBinaryName((TypeElement)element));
        if (string == null) {
            JavacNameTable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAsterisk(Name name) {
        if (this.myAsterisk == null) {
            this.myAsterisk = this.myElements.getName("*");
        }
        return this.myAsterisk == name;
    }

    public boolean isInit(Name name) {
        if (this.myInit == null) {
            this.myInit = this.myElements.getName("<init>");
        }
        return this.myInit == name;
    }

    @Nullable(value="if the type is not loaded to javac name table")
    public TypeElement getStreamElement() {
        if (this.myStreamElement == null) {
            this.myStreamElement = this.myElements.getTypeElement("java.util.stream.Stream");
        }
        return this.myStreamElement;
    }

    @Nullable(value="if the type is not loaded to javac name table")
    public TypeElement getIteratorElement() {
        if (this.myIteratorElement == null) {
            this.myIteratorElement = this.myElements.getTypeElement("java.util.Iterator");
        }
        return this.myIteratorElement;
    }

    @Nullable(value="if the type is not loaded to javac name table")
    public TypeElement getIterableElement() {
        if (this.myIterableElement == null) {
            this.myIterableElement = this.myElements.getTypeElement("java.lang.Iterable");
        }
        return this.myIterableElement;
    }

    @NotNull
    public TypeElement getStringElement() {
        if (this.myStringElement == null) {
            this.myStringElement = this.myElements.getTypeElement("java.lang.String");
        }
        TypeElement typeElement = this.myStringElement;
        if (typeElement == null) {
            JavacNameTable.$$$reportNull$$$0(2);
        }
        return typeElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/javac/ast/api/JavacNameTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBinaryName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

