/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrMethodElementType;

public class GrMethodStub
extends StubBase<GrMethod>
implements NamedStub<GrMethod> {
    public static final byte IS_DEPRECATED_BY_DOC_TAG = 1;
    public static final byte HAS_BLOCK = 2;
    public static final byte HAS_COMMENT = 4;
    private final StringRef myName;
    private final String[] myAnnotations;
    private final String[] myNamedParameters;
    private final String myTypeText;
    private final byte myFlags;

    public GrMethodStub(StubElement parent, StringRef name, String[] annotations, String @NotNull [] namedParameters, @NotNull GrMethodElementType elementType, @Nullable String typeText, byte flags) {
        if (elementType == null) {
            GrMethodStub.$$$reportNull$$$0(0);
        }
        if (namedParameters == null) {
            GrMethodStub.$$$reportNull$$$0(1);
        }
        super(parent, (IStubElementType)elementType);
        this.myName = name;
        this.myAnnotations = annotations;
        this.myNamedParameters = namedParameters;
        this.myTypeText = typeText;
        this.myFlags = flags;
    }

    @NotNull
    public String getName() {
        String string = StringRef.toString((StringRef)this.myName);
        if (string == null) {
            GrMethodStub.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    public String @NotNull [] getNamedParameters() {
        if (this.myNamedParameters == null) {
            GrMethodStub.$$$reportNull$$$0(3);
        }
        return this.myNamedParameters;
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isDeprecatedByDoc() {
        return (this.myFlags & 1) != 0;
    }

    public boolean hasBlock() {
        return (this.myFlags & 2) != 0;
    }

    public boolean hasComment() {
        return (this.myFlags & 4) != 0;
    }

    public static byte buildFlags(GrMethod method) {
        byte f = 0;
        if (PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)method)) {
            f = (byte)(f | 1);
        }
        if (method.hasBlock()) {
            f = (byte)(f | 2);
        }
        if (method.getDocComment() != null) {
            f = (byte)(f | 4);
        }
        return f;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrMethodStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/GrMethodStub";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

