/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Char2DArrays;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.CheckReturnValue;

public class Char2DArrayAssert
extends Abstract2DArrayAssert<Char2DArrayAssert, char[][], Character> {
    private final Failures failures = Failures.instance();
    protected Char2DArrays char2dArrays = Char2DArrays.instance();

    public Char2DArrayAssert(char[][] actual) {
        super(actual, Char2DArrayAssert.class);
    }

    @Override
    public Char2DArrayAssert isDeepEqualTo(char[][] expected) {
        if (this.actual == expected) {
            return (Char2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((char[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((char[][])this.actual).length, expected.length));
        }
        for (int i = 0; i < ((char[][])this.actual).length; ++i) {
            char[] actualSubArray = ((char[][])this.actual)[i];
            char[] expectedSubArray = expected[i];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(Character.valueOf(actualSubArray[j]), Character.valueOf(expectedSubArray[j]), i, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Char2DArrayAssert)this.myself;
    }

    @Override
    public Char2DArrayAssert isEqualTo(Object expected) {
        return (Char2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.char2dArrays.assertNullOrEmpty(this.info, (char[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.char2dArrays.assertEmpty(this.info, (char[][])this.actual);
    }

    @Override
    public Char2DArrayAssert isNotEmpty() {
        this.char2dArrays.assertNotEmpty(this.info, (char[][])this.actual);
        return (Char2DArrayAssert)this.myself;
    }

    @Override
    public Char2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.char2dArrays.assertHasDimensions(this.info, (char[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Char2DArrayAssert)this.myself;
    }

    @Override
    public Char2DArrayAssert hasNumberOfRows(int expected) {
        this.char2dArrays.assertNumberOfRows(this.info, (char[][])this.actual, expected);
        return (Char2DArrayAssert)this.myself;
    }

    @Override
    public Char2DArrayAssert hasSameDimensionsAs(Object array) {
        this.char2dArrays.assertHasSameDimensionsAs(this.info, (char[][])this.actual, array);
        return (Char2DArrayAssert)this.myself;
    }

    public Char2DArrayAssert contains(char[] value, Index index) {
        this.char2dArrays.assertContains(this.info, (char[][])this.actual, value, index);
        return (Char2DArrayAssert)this.myself;
    }

    public Char2DArrayAssert doesNotContain(char[] value, Index index) {
        this.char2dArrays.assertDoesNotContain(this.info, (char[][])this.actual, value, index);
        return (Char2DArrayAssert)this.myself;
    }

    @CheckReturnValue
    public Char2DArrayAssert inUnicode() {
        this.info.useUnicodeRepresentation();
        return (Char2DArrayAssert)this.myself;
    }
}

