/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.runtime.PerfDataEntry;
import sun.jvm.hotspot.runtime.PerfDataPrologue;
import sun.jvm.hotspot.runtime.PerfMemory;
import sun.jvm.hotspot.tools.Tool;

public class JSnap
extends Tool {
    public JSnap() {
    }

    public JSnap(JVMDebugger d) {
        super(d);
    }

    @Override
    public void run() {
        final PrintStream out = System.out;
        if (PerfMemory.initialized()) {
            PerfDataPrologue prologue = PerfMemory.prologue();
            if (prologue.accessible()) {
                PerfMemory.iterate(new PerfMemory.PerfDataEntryVisitor(){

                    @Override
                    public boolean visit(PerfDataEntry pde) {
                        if (pde.supported()) {
                            out.print(pde.name());
                            out.print('=');
                            out.println(pde.valueAsString());
                        }
                        return true;
                    }
                });
            } else {
                out.println("PerfMemory is not accessible");
            }
        } else {
            out.println("PerfMemory is not initialized");
        }
    }

    public static void main(String[] args) {
        JSnap js = new JSnap();
        js.execute(args);
    }
}

