/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import org.keycloak.common.util.Base64;

public class Base64Url {
    public static String encode(byte[] bytes) {
        String s = Base64.encodeBytes(bytes);
        return Base64Url.encodeBase64ToBase64Url(s);
    }

    public static byte[] decode(String s) {
        s = Base64Url.encodeBase64UrlToBase64(s);
        try {
            return Base64.decode(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeBase64ToBase64Url(String base64) {
        String s = base64.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static String encodeBase64UrlToBase64(String base64Url) {
        String s = base64Url.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new RuntimeException("Illegal base64url string!");
            }
        }
        return s;
    }
}

