/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class SkipFirstLimitHandler
extends AbstractLimitHandler {
    public static final SkipFirstLimitHandler INSTANCE = new SkipFirstLimitHandler(true);
    private final boolean variableLimit;

    public SkipFirstLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, parameterMarkerStrategy, queryOptions.getLimit());
    }

    public String processSql(String sql, Limit limit) {
        return this.processSql(sql, -1, null, limit);
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, @Nullable Limit limit) {
        boolean hasFirstRow = SkipFirstLimitHandler.hasFirstRow((Limit)limit);
        boolean hasMaxRows = SkipFirstLimitHandler.hasMaxRows((Limit)limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (this.supportsVariableLimit()) {
            if (ParameterMarkerStrategyStandard.isStandardRenderer((ParameterMarkerStrategy)parameterMarkerStrategy)) {
                if (hasFirstRow) {
                    skipFirst.append(" skip ?");
                }
                if (hasMaxRows) {
                    skipFirst.append(" first ?");
                }
            } else {
                String marker = parameterMarkerStrategy.createMarker(1, null);
                if (hasMaxRows) {
                    skipFirst.append(" skip ");
                    skipFirst.append(marker);
                    marker = parameterMarkerStrategy.createMarker(2, null);
                }
                if (hasFirstRow) {
                    skipFirst.append(" first ");
                    skipFirst.append(marker);
                }
            }
        } else {
            if (hasFirstRow) {
                skipFirst.append(" skip ").append(limit.getFirstRow());
            }
            if (hasMaxRows) {
                skipFirst.append(" first ").append(this.getMaxOrLimit(limit));
            }
        }
        return SkipFirstLimitHandler.insertAfterSelect((String)skipFirst.toString(), (String)sql);
    }

    public final boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffset() {
        return true;
    }

    public final boolean bindLimitParametersFirst() {
        return true;
    }

    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }

    public boolean processSqlMutatesState() {
        return false;
    }

    public int getParameterPositionStart(Limit limit) {
        return this.supportsVariableLimit() && SkipFirstLimitHandler.hasMaxRows((Limit)limit) ? (SkipFirstLimitHandler.hasFirstRow((Limit)limit) ? 3 : 2) : (this.supportsVariableLimit() && SkipFirstLimitHandler.hasFirstRow((Limit)limit) ? 2 : 1);
    }
}

