/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.storage.json.internal.migration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.storage.json.internal.migration.TypeMigrationException;
import org.openhab.core.storage.json.internal.migration.TypeMigrator;

@NonNullByDefault
public class ThingImplTypeMigrator
implements TypeMigrator {
    @Override
    public String getOldType() {
        return "org.openhab.core.thing.internal.ThingImpl";
    }

    @Override
    public String getNewType() {
        return "org.openhab.core.thing.internal.ThingStorageEntity";
    }

    @Override
    public JsonElement migrate(JsonElement oldValue) throws TypeMigrationException {
        JsonObject newValue = oldValue.deepCopy().getAsJsonObject();
        this.segmentUidToStringUid(newValue, "uid", "UID");
        this.segmentUidToStringUid(newValue, "bridgeUID");
        this.segmentUidToStringUid(newValue, "thingTypeUID");
        for (JsonElement jsonElement : newValue.get("channels").getAsJsonArray()) {
            JsonObject channel = jsonElement.getAsJsonObject();
            channel.add("itemType", channel.remove("acceptedItemType"));
            channel.add("configuration", channel.remove("configuration").getAsJsonObject().get("properties"));
            this.segmentUidToStringUid(channel, "uid");
            this.segmentUidToStringUid(channel, "channelTypeUID");
        }
        newValue.add("configuration", newValue.remove("configuration").getAsJsonObject().get("properties"));
        newValue.addProperty("isBridge", Boolean.valueOf(false));
        return newValue;
    }

    private void segmentUidToStringUid(JsonObject object, String name) {
        this.segmentUidToStringUid(object, name, name);
    }

    private void segmentUidToStringUid(JsonObject object, String oldName, String newName) {
        JsonElement element = object.remove(oldName);
        if (element != null) {
            Spliterator segments = element.getAsJsonObject().get("segments").getAsJsonArray().spliterator();
            String uid = StreamSupport.stream(segments, false).map(JsonElement::getAsString).collect(Collectors.joining(":"));
            object.addProperty(newName, uid);
        }
    }
}

