/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.ActionDTOMapper;
import org.openhab.core.automation.dto.ActionTypeDTO;
import org.openhab.core.automation.dto.CompositeActionTypeDTO;
import org.openhab.core.automation.dto.ModuleTypeDTOMapper;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.config.core.dto.ConfigDescriptionDTOMapper;

@NonNullByDefault
public class ActionTypeDTOMapper
extends ModuleTypeDTOMapper {
    public static ActionTypeDTO map(ActionType actionType) {
        return ActionTypeDTOMapper.map(actionType, new ActionTypeDTO());
    }

    public static CompositeActionTypeDTO map(CompositeActionType actionType) {
        CompositeActionTypeDTO actionTypeDto = ActionTypeDTOMapper.map(actionType, new CompositeActionTypeDTO());
        actionTypeDto.children = ActionDTOMapper.map(actionType.getChildren());
        return actionTypeDto;
    }

    public static ActionType map(CompositeActionTypeDTO actionTypeDto) {
        if (actionTypeDto.children == null || actionTypeDto.children.isEmpty()) {
            return new ActionType(actionTypeDto.uid, ConfigDescriptionDTOMapper.map((List)actionTypeDto.configDescriptions), actionTypeDto.label, actionTypeDto.description, actionTypeDto.tags, actionTypeDto.visibility, actionTypeDto.inputs, actionTypeDto.outputs);
        }
        return new CompositeActionType(actionTypeDto.uid, ConfigDescriptionDTOMapper.map((List)actionTypeDto.configDescriptions), actionTypeDto.label, actionTypeDto.description, actionTypeDto.tags, actionTypeDto.visibility, actionTypeDto.inputs, actionTypeDto.outputs, ActionDTOMapper.mapDto(actionTypeDto.children));
    }

    public static List<ActionTypeDTO> map(@Nullable Collection<ActionType> types) {
        if (types == null) {
            return List.of();
        }
        ArrayList<ActionTypeDTO> dtos = new ArrayList<ActionTypeDTO>(types.size());
        for (ActionType type : types) {
            if (type instanceof CompositeActionType) {
                CompositeActionType actionType = (CompositeActionType)type;
                dtos.add(ActionTypeDTOMapper.map(actionType));
                continue;
            }
            dtos.add(ActionTypeDTOMapper.map(type));
        }
        return dtos;
    }

    private static <T extends ActionTypeDTO> T map(ActionType actionType, T actionTypeDto) {
        ActionTypeDTOMapper.fillProperties(actionType, actionTypeDto);
        actionTypeDto.inputs = actionType.getInputs();
        actionTypeDto.outputs = actionType.getOutputs();
        return actionTypeDto;
    }
}

