/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.EnumSet;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonRegExpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    public boolean characterNeedsEscaping(char c, boolean isInClass) {
        return c == '\"' || c == '\'';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    public boolean supportsPossessiveQuantifiers(RegExpElement context) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)context);
        return host != null && LanguageLevel.forElement((PsiElement)host).isAtLeast(LanguageLevel.PYTHON311);
    }

    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    public boolean supportConditionalCondition(RegExpAtom condition) {
        if (condition instanceof RegExpGroup) {
            return false;
        }
        return condition.getNode().getFirstChildNode().getElementType() == RegExpTT.GROUP_BEGIN;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group2) {
        return group2.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isPythonNamedGroupRef();
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
        if (enumSet == null) {
            PythonRegExpHost.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            PythonRegExpHost.$$$reportNull$$$0(1);
        }
        return RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION;
    }

    public Long getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            PythonRegExpHost.$$$reportNull$$$0(2);
        }
        try {
            long result2 = Long.parseLong(number.getUnescapedText());
            if (result2 >= 0xFFFFFFFFL) {
                return null;
            }
            return result2;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            PythonRegExpHost.$$$reportNull$$$0(3);
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return this.myPropertiesProvider.getAllKnownProperties();
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name2) {
        return this.myPropertiesProvider.getPropertyDescription(name2);
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return this.myPropertiesProvider.getKnownCharacterClasses();
    }

    public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)namedCharacter.getProject()).getInjectionHost((PsiElement)namedCharacter);
        return host == null || LanguageLevel.forElement((PsiElement)host).isAtLeast(LanguageLevel.PYTHON38);
    }

    public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return UnicodeCharacterNames.getCodePoint((String)namedCharacter.getName()) >= 0;
    }

    public boolean isValidGroupName(String name2, @NotNull RegExpGroup group2) {
        int offset;
        int codePoint;
        if (group2 == null) {
            PythonRegExpHost.$$$reportNull$$$0(4);
        }
        if (!Character.isUnicodeIdentifierStart(codePoint = name2.codePointAt(offset = 0))) {
            return false;
        }
        offset += Character.charCount(codePoint);
        while (offset < name2.length()) {
            codePoint = name2.codePointAt(offset);
            if (!Character.isUnicodeIdentifierPart(codePoint)) {
                return false;
            }
            offset += Character.charCount(codePoint);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PythonRegExpHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PythonRegExpHost";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

