/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.CoreTextFieldKt;
import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.TextFieldDelegate;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.autofill.ContentDataType;
import androidx.compose.ui.autofill.ContentType;
import androidx.compose.ui.autofill.FillableData;
import androidx.compose.ui.autofill.FillableDataKt;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import androidx.compose.ui.text.input.TransformedText;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002BW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\f\u0010<\u001a\u00020=*\u00020>H\u0016JV\u0010?\u001a\u00020=2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010@\u001a\u00020=2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010A\u001a\u00020B2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010&R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010$\"\u0004\b)\u0010&R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010$\u00a8\u0006C"}, d2={"Landroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode;", "Landroidx/compose/ui/node/DelegatingNode;", "Landroidx/compose/ui/node/SemanticsModifierNode;", "transformedText", "Landroidx/compose/ui/text/input/TransformedText;", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "state", "Landroidx/compose/foundation/text/LegacyTextFieldState;", "readOnly", "", "enabled", "isPassword", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "manager", "Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "focusRequester", "Landroidx/compose/ui/focus/FocusRequester;", "<init>", "(Landroidx/compose/ui/text/input/TransformedText;Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/foundation/text/LegacyTextFieldState;ZZZLandroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;Landroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/ui/focus/FocusRequester;)V", "getTransformedText", "()Landroidx/compose/ui/text/input/TransformedText;", "setTransformedText", "(Landroidx/compose/ui/text/input/TransformedText;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "getState", "()Landroidx/compose/foundation/text/LegacyTextFieldState;", "setState", "(Landroidx/compose/foundation/text/LegacyTextFieldState;)V", "getReadOnly", "()Z", "setReadOnly", "(Z)V", "getEnabled", "setEnabled", "setPassword", "getOffsetMapping", "()Landroidx/compose/ui/text/input/OffsetMapping;", "setOffsetMapping", "(Landroidx/compose/ui/text/input/OffsetMapping;)V", "getManager", "()Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "setManager", "(Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;)V", "getImeOptions", "()Landroidx/compose/ui/text/input/ImeOptions;", "setImeOptions", "(Landroidx/compose/ui/text/input/ImeOptions;)V", "getFocusRequester", "()Landroidx/compose/ui/focus/FocusRequester;", "setFocusRequester", "(Landroidx/compose/ui/focus/FocusRequester;)V", "shouldMergeDescendantSemantics", "getShouldMergeDescendantSemantics", "applySemantics", "", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "updateNodeSemantics", "handleTextUpdateFromSemantics", "text", "", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCoreTextFieldSemanticsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTextFieldSemanticsModifier.kt\nandroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1#2:363\n*E\n"})
public final class CoreTextFieldSemanticsModifierNode
extends DelegatingNode
implements SemanticsModifierNode {
    @NotNull
    private TransformedText transformedText;
    @NotNull
    private TextFieldValue value;
    @NotNull
    private LegacyTextFieldState state;
    private boolean readOnly;
    private boolean enabled;
    private boolean isPassword;
    @NotNull
    private OffsetMapping offsetMapping;
    @NotNull
    private TextFieldSelectionManager manager;
    @NotNull
    private ImeOptions imeOptions;
    @NotNull
    private FocusRequester focusRequester;
    public static final int $stable = 8;

    public CoreTextFieldSemanticsModifierNode(@NotNull TransformedText transformedText, @NotNull TextFieldValue value, @NotNull LegacyTextFieldState state, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        this.transformedText = transformedText;
        this.value = value;
        this.state = state;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.isPassword = isPassword;
        this.offsetMapping = offsetMapping;
        this.manager = manager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        this.manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode._init_$lambda$0(this)));
    }

    @NotNull
    public final TransformedText getTransformedText() {
        return this.transformedText;
    }

    public final void setTransformedText(@NotNull TransformedText transformedText) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"<set-?>");
        this.transformedText = transformedText;
    }

    @NotNull
    public final TextFieldValue getValue() {
        return this.value;
    }

    public final void setValue(@NotNull TextFieldValue textFieldValue) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
        this.value = textFieldValue;
    }

    @NotNull
    public final LegacyTextFieldState getState() {
        return this.state;
    }

    public final void setState(@NotNull LegacyTextFieldState legacyTextFieldState) {
        Intrinsics.checkNotNullParameter((Object)legacyTextFieldState, (String)"<set-?>");
        this.state = legacyTextFieldState;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean isPassword() {
        return this.isPassword;
    }

    public final void setPassword(boolean bl) {
        this.isPassword = bl;
    }

    @NotNull
    public final OffsetMapping getOffsetMapping() {
        return this.offsetMapping;
    }

    public final void setOffsetMapping(@NotNull OffsetMapping offsetMapping) {
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"<set-?>");
        this.offsetMapping = offsetMapping;
    }

    @NotNull
    public final TextFieldSelectionManager getManager() {
        return this.manager;
    }

    public final void setManager(@NotNull TextFieldSelectionManager textFieldSelectionManager) {
        Intrinsics.checkNotNullParameter((Object)textFieldSelectionManager, (String)"<set-?>");
        this.manager = textFieldSelectionManager;
    }

    @NotNull
    public final ImeOptions getImeOptions() {
        return this.imeOptions;
    }

    public final void setImeOptions(@NotNull ImeOptions imeOptions) {
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"<set-?>");
        this.imeOptions = imeOptions;
    }

    @NotNull
    public final FocusRequester getFocusRequester() {
        return this.focusRequester;
    }

    public final void setFocusRequester(@NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"<set-?>");
        this.focusRequester = focusRequester;
    }

    @Override
    public boolean getShouldMergeDescendantSemantics() {
        return true;
    }

    @Override
    public void applySemantics(@NotNull SemanticsPropertyReceiver $this$applySemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        SemanticsPropertiesKt.setInputText($this$applySemantics, this.value.getAnnotatedString());
        SemanticsPropertiesKt.setEditableText($this$applySemantics, this.transformedText.getText());
        SemanticsPropertiesKt.setTextSelectionRange-FDrldGo($this$applySemantics, this.value.getSelection-d9O1mEE());
        SemanticsPropertiesKt.setContentDataType($this$applySemantics, ContentDataType.Companion.getText());
        FillableData fillableData = FillableDataKt.createFromText(FillableData.Companion, this.value.getAnnotatedString());
        if (fillableData != null) {
            FillableData it = fillableData;
            boolean bl = false;
            SemanticsPropertiesKt.setFillableData($this$applySemantics, it);
        }
        SemanticsPropertiesKt.onFillData$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$1(this, arg_0), 1, null);
        int n = this.imeOptions.getKeyboardType-PjHm6EE();
        if (KeyboardType.equals-impl0(n, KeyboardType.Companion.getEmail-PjHm6EE())) {
            SemanticsPropertiesKt.setContentType($this$applySemantics, ContentType.Companion.getEmailAddress());
        } else if (KeyboardType.equals-impl0(n, KeyboardType.Companion.getPassword-PjHm6EE()) || KeyboardType.equals-impl0(n, KeyboardType.Companion.getNumberPassword-PjHm6EE())) {
            SemanticsPropertiesKt.setContentType($this$applySemantics, ContentType.Companion.getPassword());
        } else if (KeyboardType.equals-impl0(n, KeyboardType.Companion.getPhone-PjHm6EE())) {
            SemanticsPropertiesKt.setContentType($this$applySemantics, ContentType.Companion.getPhoneNumber());
        }
        if (!this.enabled) {
            SemanticsPropertiesKt.disabled($this$applySemantics);
        }
        if (this.isPassword) {
            SemanticsPropertiesKt.password($this$applySemantics);
        }
        boolean editable = this.enabled && !this.readOnly;
        SemanticsPropertiesKt.setEditable($this$applySemantics, editable);
        SemanticsPropertiesKt.getTextLayoutResult$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$2(this, arg_0), 1, null);
        if (editable) {
            SemanticsPropertiesKt.setText$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$3(this, arg_0), 1, null);
            SemanticsPropertiesKt.insertTextAtCursor$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$4(this, $this$applySemantics, arg_0), 1, null);
        }
        SemanticsPropertiesKt.setSelection$default($this$applySemantics, null, (arg_0, arg_1, arg_2) -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$5(this, arg_0, arg_1, arg_2), 1, null);
        SemanticsPropertiesKt.onImeAction-9UiTYpY$default($this$applySemantics, this.imeOptions.getImeAction-eUduSuo(), null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$6(this), 2, null);
        SemanticsPropertiesKt.onClick$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$7(this), 1, null);
        SemanticsPropertiesKt.onLongClick$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$8(this), 1, null);
        if (!TextRange.getCollapsed-impl(this.value.getSelection-d9O1mEE()) && !this.isPassword) {
            SemanticsPropertiesKt.copyText$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$9(this), 1, null);
            if (this.enabled && !this.readOnly) {
                SemanticsPropertiesKt.cutText$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$10(this), 1, null);
            }
        }
        if (this.enabled && !this.readOnly) {
            SemanticsPropertiesKt.pasteText$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$11(this), 1, null);
        }
    }

    public final void updateNodeSemantics(@NotNull TransformedText transformedText, @NotNull TextFieldValue value, @NotNull LegacyTextFieldState state, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        boolean previousEditable = this.enabled && !this.readOnly;
        boolean previousEnabled = this.enabled;
        boolean previousIsPassword = this.isPassword;
        ImeOptions previousImeOptions = this.imeOptions;
        TextFieldSelectionManager previousManager = this.manager;
        boolean editable = enabled && !readOnly;
        this.transformedText = transformedText;
        this.value = value;
        this.state = state;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.offsetMapping = offsetMapping;
        this.manager = manager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        if (enabled != previousEnabled || editable != previousEditable || !Intrinsics.areEqual((Object)imeOptions, (Object)previousImeOptions) || isPassword != previousIsPassword || !TextRange.getCollapsed-impl(value.getSelection-d9O1mEE())) {
            SemanticsModifierNodeKt.invalidateSemantics(this);
        }
        if (!Intrinsics.areEqual((Object)manager, (Object)previousManager)) {
            manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode.updateNodeSemantics$lambda$0(this)));
        }
    }

    private final void handleTextUpdateFromSemantics(LegacyTextFieldState state, String text, boolean readOnly, boolean enabled) {
        if (readOnly || !enabled) {
            return;
        }
        TextInputSession textInputSession2 = state.getInputSession();
        if (textInputSession2 != null) {
            TextInputSession session2 = textInputSession2;
            boolean bl = false;
            Object[] objectArray = new EditCommand[]{new DeleteAllCommand(), new CommitTextCommand(text, 1)};
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), state.getProcessor(), state.getOnValueChange(), session2);
        } else {
            CoreTextFieldSemanticsModifierNode $this$handleTextUpdateFromSemantics_u24lambda_u241 = this;
            boolean bl = false;
            state.getOnValueChange().invoke((Object)new TextFieldValue(text, TextRangeKt.TextRange(text.length()), null, 4, null));
        }
    }

    private static final Unit _init_$lambda$0(CoreTextFieldSemanticsModifierNode this$0) {
        DelegatableNodeKt.requestAutofill(this$0);
        return Unit.INSTANCE;
    }

    private static final boolean applySemantics$lambda$1(CoreTextFieldSemanticsModifierNode this$0, FillableData fillableData) {
        Intrinsics.checkNotNullParameter((Object)fillableData, (String)"fillableData");
        this$0.state.setJustAutofilled(true);
        this$0.state.setAutofillHighlightOn(true);
        LegacyTextFieldState legacyTextFieldState = this$0.state;
        CharSequence charSequence = fillableData.getTextValue();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type kotlin.String");
        this$0.handleTextUpdateFromSemantics(legacyTextFieldState, (String)charSequence, this$0.readOnly, this$0.enabled);
        return true;
    }

    private static final boolean applySemantics$lambda$2(CoreTextFieldSemanticsModifierNode this$0, List it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getLayoutResult() != null) {
            TextLayoutResultProxy textLayoutResultProxy = this$0.state.getLayoutResult();
            Intrinsics.checkNotNull((Object)textLayoutResultProxy);
            it.add(textLayoutResultProxy.getValue());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean applySemantics$lambda$3(CoreTextFieldSemanticsModifierNode this$0, AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this$0.handleTextUpdateFromSemantics(this$0.state, text.getText(), this$0.readOnly, this$0.enabled);
        return true;
    }

    private static final boolean applySemantics$lambda$4(CoreTextFieldSemanticsModifierNode this$0, SemanticsPropertyReceiver $this_applySemantics, AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this$0.readOnly || !this$0.enabled) {
            return false;
        }
        TextInputSession textInputSession2 = this$0.state.getInputSession();
        if (textInputSession2 != null) {
            TextInputSession session2 = textInputSession2;
            boolean bl = false;
            Object[] objectArray = new EditCommand[]{new FinishComposingTextCommand(), new CommitTextCommand(text, 1)};
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), this$0.state.getProcessor(), this$0.state.getOnValueChange(), session2);
        } else {
            SemanticsPropertyReceiver $this$applySemantics_u24lambda_u244_u241 = $this_applySemantics;
            boolean bl = false;
            String string = this$0.value.getText();
            int n = TextRange.getStart-impl(this$0.value.getSelection-d9O1mEE());
            int n2 = TextRange.getEnd-impl(this$0.value.getSelection-d9O1mEE());
            String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)text)).toString();
            long newCursor = TextRangeKt.TextRange(TextRange.getStart-impl(this$0.value.getSelection-d9O1mEE()) + text.length());
            this$0.state.getOnValueChange().invoke((Object)new TextFieldValue(newText, newCursor, null, 4, null));
        }
        return true;
    }

    private static final boolean applySemantics$lambda$5(CoreTextFieldSemanticsModifierNode this$0, int selectionStart, int selectionEnd, boolean relativeToOriginalText) {
        boolean bl;
        int end;
        int start = relativeToOriginalText ? selectionStart : this$0.offsetMapping.transformedToOriginal(selectionStart);
        int n = end = relativeToOriginalText ? selectionEnd : this$0.offsetMapping.transformedToOriginal(selectionEnd);
        if (!this$0.enabled) {
            bl = false;
        } else if (start == TextRange.getStart-impl(this$0.value.getSelection-d9O1mEE()) && end == TextRange.getEnd-impl(this$0.value.getSelection-d9O1mEE())) {
            bl = false;
        } else if (Math.min(start, end) >= 0 && Math.max(start, end) <= this$0.value.getAnnotatedString().length()) {
            if (relativeToOriginalText || start == end) {
                this$0.manager.exitSelectionMode$foundation();
            } else {
                TextFieldSelectionManager.enterSelectionMode$foundation$default(this$0.manager, false, 1, null);
            }
            this$0.state.getOnValueChange().invoke((Object)new TextFieldValue(this$0.value.getAnnotatedString(), TextRangeKt.TextRange(start, end), null, 4, null));
            bl = true;
        } else {
            this$0.manager.exitSelectionMode$foundation();
            bl = false;
        }
        return bl;
    }

    private static final boolean applySemantics$lambda$6(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.state.getOnImeActionPerformed().invoke((Object)ImeAction.box-impl(this$0.imeOptions.getImeAction-eUduSuo()));
        return true;
    }

    private static final boolean applySemantics$lambda$7(CoreTextFieldSemanticsModifierNode this$0) {
        CoreTextFieldKt.requestFocusAndShowKeyboardIfNeeded(this$0.state, this$0.focusRequester, !this$0.readOnly);
        return true;
    }

    private static final boolean applySemantics$lambda$8(CoreTextFieldSemanticsModifierNode this$0) {
        TextFieldSelectionManager.enterSelectionMode$foundation$default(this$0.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$9(CoreTextFieldSemanticsModifierNode this$0) {
        TextFieldSelectionManager.copy$foundation$default(this$0.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$10(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.manager.cut$foundation();
        return true;
    }

    private static final boolean applySemantics$lambda$11(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.manager.paste$foundation();
        return true;
    }

    private static final Unit updateNodeSemantics$lambda$0(CoreTextFieldSemanticsModifierNode this$0) {
        DelegatableNodeKt.requestAutofill(this$0);
        return Unit.INSTANCE;
    }
}

