/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BitSet;
import scala.collection.BitSetOps;
import scala.collection.BitSetOps$;
import scala.collection.Factory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SortedIterableFactory;
import scala.collection.SortedOps;
import scala.collection.SortedSetFactoryDefaults;
import scala.collection.SortedSetOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.StrictOptimizedSetOps;
import scala.collection.immutable.StrictOptimizedSortedSetOps;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class BitSet
extends AbstractSet<Object>
implements SortedSet<Object>,
StrictOptimizedSortedSetOps<Object, SortedSet, BitSet>,
scala.collection.BitSet,
Serializable {
    public static Object fill(int n, Function0 function0) {
        return BitSet$.MODULE$.fill(n, function0);
    }

    public static BitSet fromBitMask(long[] lArray) {
        return BitSet$.MODULE$.fromBitMask(lArray);
    }

    public static Builder<Object, BitSet> newBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    public static Factory<Object, BitSet> specificIterableFactory() {
        return BitSet$.MODULE$.specificIterableFactory();
    }

    public BitSet() {
        SortedOps.$init$(this);
        SortedSetOps.$init$(this);
        SortedSetFactoryDefaults.$init$(this);
        scala.collection.SortedSet.$init$(this);
        SortedSet.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        scala.collection.StrictOptimizedSetOps.$init$(this);
        scala.collection.StrictOptimizedSortedSetOps.$init$(this);
        StrictOptimizedSetOps.$init$(this);
        BitSetOps.$init$(this);
        scala.collection.BitSet.$init$(this);
    }

    @Override
    public int compare(Object k0, Object k1) {
        return SortedOps.compare$(this, k0, k1);
    }

    @Override
    public Object range(Object from, Object until) {
        return SortedOps.range$(this, from, until);
    }

    @Override
    public final Object from(Object from) {
        return SortedOps.from$(this, from);
    }

    @Override
    public Object rangeFrom(Object from) {
        return SortedOps.rangeFrom$(this, from);
    }

    @Override
    public final Object until(Object until) {
        return SortedOps.until$(this, until);
    }

    @Override
    public Object rangeUntil(Object until) {
        return SortedOps.rangeUntil$(this, until);
    }

    @Override
    public final Object to(Object to) {
        return SortedOps.to$(this, to);
    }

    @Override
    public Iterator keysIteratorFrom(Object start) {
        return SortedSetOps.keysIteratorFrom$(this, start);
    }

    @Override
    public Object firstKey() {
        return SortedSetOps.firstKey$(this);
    }

    @Override
    public Object lastKey() {
        return SortedSetOps.lastKey$(this);
    }

    @Override
    public Option minAfter(Object key) {
        return SortedSetOps.minAfter$(this, key);
    }

    @Override
    public Option maxBefore(Object key) {
        return SortedSetOps.maxBefore$(this, key);
    }

    @Override
    public SortedSetOps rangeTo(Object to) {
        return SortedSetOps.rangeTo$(this, to);
    }

    @Override
    public SortedSetOps.WithFilter<Object, scala.collection.immutable.Set, SortedSet> withFilter(Function1<Object, Object> p) {
        return SortedSetFactoryDefaults.withFilter$(this, p);
    }

    @Override
    public boolean equals(Object that) {
        return scala.collection.SortedSet.equals$(this, that);
    }

    @Override
    public SortedIterableFactory<SortedSet> sortedIterableFactory() {
        return SortedSet.sortedIterableFactory$(this);
    }

    @Override
    public Tuple2<BitSet, BitSet> span(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.Set<A1>, scala.collection.immutable.Set<A2>> unzip(Function1<Object, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.immutable.Set<A1>, scala.collection.immutable.Set<A2>, scala.collection.immutable.Set<A3>> unzip3(Function1<Object, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<Object, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<Object, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<Object, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<Object, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<Object, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.Set<A1>, scala.collection.immutable.Set<A2>> partitionMap(Function1<Object, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public final Ordering<Object> ordering() {
        return BitSetOps.ordering$(this);
    }

    @Override
    public boolean contains(int elem) {
        return BitSetOps.contains$(this, elem);
    }

    @Override
    public Iterator<Object> iterator() {
        return BitSetOps.iterator$(this);
    }

    @Override
    public Iterator<Object> iteratorFrom(int start) {
        return BitSetOps.iteratorFrom$(this, start);
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<Object, S> shape) {
        return (S)BitSetOps.stepper$(this, shape);
    }

    @Override
    public int size() {
        return BitSetOps.size$(this);
    }

    @Override
    public boolean isEmpty() {
        return BitSetOps.isEmpty$(this);
    }

    @Override
    public <B> int max(Ordering<B> ord) {
        return BitSetOps.max$(this, ord);
    }

    @Override
    public <B> int min(Ordering<B> ord) {
        return BitSetOps.min$(this, ord);
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        BitSetOps.foreach$(this, f);
    }

    @Override
    public long[] toBitMask() {
        return BitSetOps.toBitMask$(this);
    }

    @Override
    public scala.collection.BitSet rangeImpl(Option from, Option until) {
        return BitSetOps.rangeImpl$(this, from, until);
    }

    @Override
    public scala.collection.BitSet concat(IterableOnce other) {
        return BitSetOps.concat$(this, other);
    }

    @Override
    public scala.collection.BitSet intersect(Set other) {
        return BitSetOps.intersect$(this, other);
    }

    @Override
    public scala.collection.BitSet diff(Set other) {
        return BitSetOps.diff$(this, other);
    }

    @Override
    public scala.collection.BitSet xor(scala.collection.BitSet other) {
        return BitSetOps.xor$(this, other);
    }

    @Override
    public final scala.collection.BitSet $up(scala.collection.BitSet other) {
        return BitSetOps.$up$(this, other);
    }

    @Override
    public Tuple2<BitSet, BitSet> partition(Function1<Object, Object> p) {
        return BitSetOps.partition$(this, p);
    }

    @Override
    public String stringPrefix() {
        return scala.collection.BitSet.stringPrefix$(this);
    }

    public /* synthetic */ int scala$collection$SortedSetOps$$super$min(Ordering ord) {
        return BoxesRunTime.unboxToInt(IterableOnceOps.min$(this, ord));
    }

    public /* synthetic */ int scala$collection$SortedSetOps$$super$max(Ordering ord) {
        return BoxesRunTime.unboxToInt(IterableOnceOps.max$(this, ord));
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return Set.equals$(this, that);
    }

    @Override
    public /* synthetic */ int scala$collection$BitSetOps$$super$max(Ordering ord) {
        return BoxesRunTime.unboxToInt(SortedSetOps.max$(this, ord));
    }

    @Override
    public /* synthetic */ int scala$collection$BitSetOps$$super$min(Ordering ord) {
        return BoxesRunTime.unboxToInt(SortedSetOps.min$(this, ord));
    }

    @Override
    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$concat(IterableOnce that) {
        return (BitSet)StrictOptimizedSetOps.concat$(this, that);
    }

    @Override
    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$intersect(Set that) {
        return (BitSet)scala.collection.SetOps.intersect$(this, that);
    }

    @Override
    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$diff(Set that) {
        return (BitSet)SetOps.diff$(this, that);
    }

    @Override
    public scala.collection.immutable.Set<Object> unsorted() {
        return this;
    }

    @Override
    public BitSet fromSpecific(IterableOnce<Object> coll) {
        return this.bitSetFactory().fromSpecific((IterableOnce)coll);
    }

    @Override
    public Builder<Object, BitSet> newSpecificBuilder() {
        return this.bitSetFactory().newBuilder();
    }

    @Override
    public BitSet empty() {
        return this.bitSetFactory().empty();
    }

    public BitSet$ bitSetFactory() {
        return BitSet$.MODULE$;
    }

    @Override
    public BitSet fromBitMaskNoCopy(long[] elems) {
        return BitSet$.MODULE$.fromBitMaskNoCopy(elems);
    }

    @Override
    public BitSet incl(int elem) {
        Predef$.MODULE$.require(elem >= 0, BitSet::incl$$anonfun$1);
        if (this.contains(elem)) {
            return this;
        }
        int idx = elem >> 6;
        return this.updateWord(idx, this.word(idx) | 1L << elem);
    }

    @Override
    public BitSet excl(int elem) {
        Predef$.MODULE$.require(elem >= 0, BitSet::excl$$anonfun$1);
        if (this.contains(elem)) {
            int idx = elem >> 6;
            return this.updateWord(idx, this.word(idx) & (1L << elem ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return this;
    }

    public abstract BitSet updateWord(int var1, long var2);

    @Override
    public BitSet map(Function1<Object, Object> f) {
        return this.strictOptimizedMap((Builder<B, C2>)this.newSpecificBuilder(), (Function1)f);
    }

    @Override
    public <B> SortedSet<B> map(Function1<Object, B> f, Ordering<B> ev) {
        return (SortedSet)scala.collection.StrictOptimizedSortedSetOps.map$(this, f, ev);
    }

    @Override
    public BitSet flatMap(Function1<Object, IterableOnce<Object>> f) {
        return this.strictOptimizedFlatMap((Builder<B, C2>)this.newSpecificBuilder(), f);
    }

    @Override
    public <B> SortedSet<B> flatMap(Function1<Object, IterableOnce<B>> f, Ordering<B> ev) {
        return (SortedSet)scala.collection.StrictOptimizedSortedSetOps.flatMap$(this, f, ev);
    }

    @Override
    public BitSet collect(PartialFunction<Object, Object> pf) {
        return this.strictOptimizedCollect((Builder<B, C2>)this.newSpecificBuilder(), (PartialFunction)pf);
    }

    @Override
    public <B> SortedSet<B> collect(PartialFunction<Object, B> pf, Ordering<B> ev) {
        return (SortedSet)scala.collection.StrictOptimizedSortedSetOps.collect$(this, pf, ev);
    }

    @Override
    public <B> SortedSet<Tuple2<Object, B>> zip(IterableOnce<B> that, Ordering<Tuple2<Object, B>> ev) {
        return (SortedSet)scala.collection.StrictOptimizedSortedSetOps.zip$(this, that, ev);
    }

    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static final Object incl$$anonfun$1() {
        return "bitset element must be >= 0";
    }

    private static final Object excl$$anonfun$1() {
        return "bitset element must be >= 0";
    }

    public static class BitSet1
    extends BitSet
    implements BitSetOps {
        private final long elems;

        public BitSet1(long elems) {
            this.elems = elems;
        }

        public long elems() {
            return this.elems;
        }

        @Override
        public int nwords() {
            return 1;
        }

        @Override
        public long word(int idx) {
            if (idx == 0) {
                return this.elems();
            }
            return 0L;
        }

        @Override
        public BitSet updateWord(int idx, long w) {
            if (idx == 0) {
                return new BitSet1(w);
            }
            if (idx == 1) {
                return BitSet$.MODULE$.scala$collection$immutable$BitSet$$$createSmall(this.elems(), w);
            }
            return this.fromBitMaskNoCopy(BitSetOps$.MODULE$.updateArray(new long[]{this.elems()}, idx, w));
        }

        @Override
        public BitSet diff(Set<Object> other) {
            Set<Object> set = other;
            if (set instanceof scala.collection.BitSet) {
                scala.collection.BitSet bitSet = (scala.collection.BitSet)set;
                scala.collection.BitSet bs = bitSet;
                int n = bs.nwords();
                if (0 == n) {
                    return this;
                }
                long newElems = this.elems() & (bs.word(0) ^ 0xFFFFFFFFFFFFFFFFL);
                if (newElems == 0L) {
                    return this.empty();
                }
                return new BitSet1(newElems);
            }
            return (BitSet)BitSetOps.diff$(this, other);
        }

        @Override
        public BitSet filterImpl(Function1<Object, Object> pred, boolean isFlipped) {
            long _elems = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, this.elems(), 0);
            if (_elems == 0L) {
                return this.empty();
            }
            return new BitSet1(_elems);
        }
    }

    public static class BitSet2
    extends BitSet
    implements BitSetOps {
        private final long elems0;
        private final long elems1;

        public BitSet2(long elems0, long elems1) {
            this.elems0 = elems0;
            this.elems1 = elems1;
        }

        public long elems0() {
            return this.elems0;
        }

        public long elems1() {
            return this.elems1;
        }

        @Override
        public int nwords() {
            return 2;
        }

        @Override
        public long word(int idx) {
            if (idx == 0) {
                return this.elems0();
            }
            if (idx == 1) {
                return this.elems1();
            }
            return 0L;
        }

        @Override
        public BitSet updateWord(int idx, long w) {
            if (idx == 0) {
                return new BitSet2(w, this.elems1());
            }
            if (idx == 1) {
                return BitSet$.MODULE$.scala$collection$immutable$BitSet$$$createSmall(this.elems0(), w);
            }
            return this.fromBitMaskNoCopy(BitSetOps$.MODULE$.updateArray(new long[]{this.elems0(), this.elems1()}, idx, w));
        }

        @Override
        public BitSet diff(Set<Object> other) {
            Set<Object> set = other;
            if (set instanceof scala.collection.BitSet) {
                scala.collection.BitSet bitSet = (scala.collection.BitSet)set;
                scala.collection.BitSet bs = bitSet;
                int n = bs.nwords();
                if (0 == n) {
                    return this;
                }
                if (1 == n) {
                    return new BitSet2(this.elems0() & (bs.word(0) ^ 0xFFFFFFFFFFFFFFFFL), this.elems1());
                }
                long _elems0 = this.elems0() & (bs.word(0) ^ 0xFFFFFFFFFFFFFFFFL);
                long _elems1 = this.elems1() & (bs.word(1) ^ 0xFFFFFFFFFFFFFFFFL);
                if (_elems1 == 0L) {
                    if (_elems0 == 0L) {
                        return this.empty();
                    }
                    return new BitSet1(_elems0);
                }
                return new BitSet2(_elems0, _elems1);
            }
            return (BitSet)BitSetOps.diff$(this, other);
        }

        @Override
        public BitSet filterImpl(Function1<Object, Object> pred, boolean isFlipped) {
            long _elems0 = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, this.elems0(), 0);
            long _elems1 = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, this.elems1(), 1);
            if (_elems1 == 0L) {
                if (_elems0 == 0L) {
                    return this.empty();
                }
                return new BitSet1(_elems0);
            }
            return new BitSet2(_elems0, _elems1);
        }
    }

    public static class BitSetN
    extends BitSet
    implements BitSetOps {
        private final long[] elems;

        public BitSetN(long[] elems) {
            this.elems = elems;
        }

        public long[] elems() {
            return this.elems;
        }

        @Override
        public int nwords() {
            return this.elems().length;
        }

        @Override
        public long word(int idx) {
            if (idx < this.nwords()) {
                return this.elems()[idx];
            }
            return 0L;
        }

        @Override
        public BitSet updateWord(int idx, long w) {
            return this.fromBitMaskNoCopy(BitSetOps$.MODULE$.updateArray(this.elems(), idx, w));
        }

        @Override
        public BitSet diff(Set<Object> that) {
            Set<Object> set = that;
            if (set instanceof scala.collection.BitSet) {
                int i;
                int thisnwords;
                scala.collection.BitSet bitSet = (scala.collection.BitSet)set;
                scala.collection.BitSet bs = bitSet;
                int bsnwords = bs.nwords();
                if (bsnwords >= (thisnwords = this.nwords())) {
                    int i2;
                    long currentWord = 0L;
                    boolean anyChanges = false;
                    for (i2 = thisnwords - 1; i2 >= 0 && currentWord == 0L; --i2) {
                        long oldWord = this.word(i2);
                        currentWord = oldWord & (bs.word(i2) ^ 0xFFFFFFFFFFFFFFFFL);
                        anyChanges = anyChanges || currentWord != oldWord;
                    }
                    int n = i2;
                    if (-1 == n) {
                        if (anyChanges) {
                            if (currentWord == 0L) {
                                return this.empty();
                            }
                            return new BitSet1(currentWord);
                        }
                        return this;
                    }
                    if (0 == n) {
                        long oldFirstWord = this.word(0);
                        long firstWord = oldFirstWord & (bs.word(0) ^ 0xFFFFFFFFFFFFFFFFL);
                        boolean bl = anyChanges = anyChanges || firstWord != oldFirstWord;
                        if (anyChanges) {
                            return new BitSet2(firstWord, currentWord);
                        }
                        return this;
                    }
                    int minimumNonZeroIndex = i2 + 1;
                    while (!anyChanges && i2 >= 0) {
                        long oldWord = this.word(i2);
                        currentWord = oldWord & (bs.word(i2) ^ 0xFFFFFFFFFFFFFFFFL);
                        anyChanges = anyChanges || currentWord != oldWord;
                        --i2;
                    }
                    if (anyChanges) {
                        Object object = Predef$.MODULE$.longArrayOps(this.elems());
                        long[] newArray = (long[])ArrayOps$.MODULE$.take$extension(object, minimumNonZeroIndex + 1);
                        newArray[i2 + 1] = currentWord;
                        while (i2 >= 0) {
                            newArray[i2] = this.word(i2) & (bs.word(i2) ^ 0xFFFFFFFFFFFFFFFFL);
                            --i2;
                        }
                        return new BitSetN(newArray);
                    }
                    return this;
                }
                boolean anyChanges = false;
                long currentWord = 0L;
                for (i = bsnwords - 1; i >= 0 && !anyChanges; --i) {
                    long oldWord = this.word(i);
                    currentWord = oldWord & (bs.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
                    anyChanges = anyChanges || currentWord != oldWord;
                }
                if (anyChanges) {
                    long[] newElems = (long[])this.elems().clone();
                    newElems[i + 1] = currentWord;
                    while (i >= 0) {
                        newElems[i] = this.word(i) & (bs.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
                        --i;
                    }
                    return this.fromBitMaskNoCopy(newElems);
                }
                return this;
            }
            return (BitSet)BitSetOps.diff$(this, that);
        }

        @Override
        public BitSet filterImpl(Function1<Object, Object> pred, boolean isFlipped) {
            int i;
            long currentWord = 0L;
            boolean anyChanges = false;
            for (i = this.nwords() - 1; i >= 0 && currentWord == 0L; --i) {
                long oldWord = this.word(i);
                currentWord = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, oldWord, i);
                anyChanges = anyChanges || currentWord != oldWord;
            }
            int n = i;
            if (-1 == n) {
                if (anyChanges) {
                    if (currentWord == 0L) {
                        return this.empty();
                    }
                    return new BitSet1(currentWord);
                }
                return this;
            }
            if (0 == n) {
                long oldFirstWord = this.word(0);
                long firstWord = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, oldFirstWord, 0);
                boolean bl = anyChanges = anyChanges || firstWord != oldFirstWord;
                if (anyChanges) {
                    return new BitSet2(firstWord, currentWord);
                }
                return this;
            }
            int minimumNonZeroIndex = i + 1;
            while (!anyChanges && i >= 0) {
                long oldWord = this.word(i);
                currentWord = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, oldWord, i);
                anyChanges = anyChanges || currentWord != oldWord;
                --i;
            }
            if (anyChanges) {
                Object object = Predef$.MODULE$.longArrayOps(this.elems());
                long[] newArray = (long[])ArrayOps$.MODULE$.take$extension(object, minimumNonZeroIndex + 1);
                newArray[i + 1] = currentWord;
                while (i >= 0) {
                    newArray[i] = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, this.word(i), i);
                    --i;
                }
                return new BitSetN(newArray);
            }
            return this;
        }

        @Override
        public long[] toBitMask() {
            return (long[])this.elems().clone();
        }
    }

    public static final class SerializationProxy
    extends BitSet.SerializationProxy {
        private static final long serialVersionUID = 3L;

        public SerializationProxy(BitSet coll) {
            super(coll);
        }

        private BitSet coll$accessor() {
            return (BitSet)super.coll();
        }

        @Override
        public Object readResolve() {
            return BitSet$.MODULE$.fromBitMaskNoCopy(this.elems());
        }
    }
}

