/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import jakarta.inject.Singleton;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.RuntimeType;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.glassfish.jersey.innate.BootstrapPreinitialization;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InternalBinder;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.servlet.WebComponent;
import org.glassfish.jersey.servlet.WebConfig;

public class ServletBootstrapPreinitialization
implements BootstrapPreinitialization {
    public void preregister(RuntimeType runtimeType, InjectionManager injectionManager) {
        if (RuntimeType.SERVER == runtimeType) {
            injectionManager.register((Binder)new WebComponent.WebComponentBinder(Collections.emptyMap(), new BootstrapWebConfig(), false));
            injectionManager.register((Binder)new InternalBinder(){

                protected void configure() {
                    ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(() -> null).to(FilterConfig.class)).in(Singleton.class)).id((long)InjectionIds.SERVLET_FILTER_CONFIG.id());
                }
            });
        }
    }

    private static class BootstrapWebConfig
    implements WebConfig {
        private BootstrapWebConfig() {
        }

        @Override
        public WebConfig.ConfigType getConfigType() {
            return WebConfig.ConfigType.ServletConfig;
        }

        @Override
        public ServletConfig getServletConfig() {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(ReflectionHelper.getClassLoaderPA(ServletContext.class));
            return (ServletConfig)Proxy.newProxyInstance(cl, new Class[]{ServletConfig.class}, (proxy, method, args) -> {
                switch (method.getName()) {
                    case "getInitParameterNames": {
                        return this.getInitParameterNames();
                    }
                }
                return null;
            });
        }

        @Override
        public FilterConfig getFilterConfig() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getInitParameter(String name) {
            return null;
        }

        @Override
        public Enumeration getInitParameterNames() {
            return Collections.enumeration(WebComponent.isJPA() ? Collections.emptyList() : List.of("unit:"));
        }

        @Override
        public ServletContext getServletContext() {
            return null;
        }
    }
}

