/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.InvalidException;
import org.netbeans.LocaleVariants;
import org.netbeans.ModuleData;
import org.netbeans.Stamps;
import org.netbeans.StandardModule;
import org.netbeans.Util;

final class StandardModuleData
extends ModuleData {
    private static final Map<File, Set<File>> extensionOwners = new HashMap<File, Set<File>>();
    private final Set<File> localeVariants;
    private final Set<File> plainExtensions;
    private final Set<File> localeExtensions;

    public StandardModuleData(Manifest manifest, StandardModule standardModule) throws InvalidException {
        super(manifest, standardModule);
        Object object;
        assert (standardModule instanceof StandardModule);
        File file = standardModule.getJarFile();
        assert (file != null) : "Cannot load extensions from classpath module " + this.getCodeNameBase();
        List<File> list = LocaleVariants.findLocaleVariantsOf(file, this.getCodeNameBase());
        this.localeVariants = !list.isEmpty() ? new HashSet<File>(list) : null;
        HashSet<File> hashSet = null;
        HashSet<File> hashSet2 = null;
        String string = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (string != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                File file2;
                Serializable serializable;
                String string2;
                try {
                    string2 = URLDecoder.decode(((StringTokenizer)object).nextToken(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException(unsupportedEncodingException);
                }
                if (string2.equals("${java.home}/lib/ext/jfxrt.jar")) {
                    serializable = new File(System.getProperty("java.home"));
                    File file3 = new File(new File((File)serializable, "lib"), "jfxrt.jar");
                    if (!file3.exists()) continue;
                    file2 = file3;
                } else {
                    if (new File(string2).isAbsolute()) {
                        Util.err.log(Level.WARNING, "Class-Path value {0} from {1} is illegal according to the Java Extension Mechanism: must be relative", new Object[]{string2, file});
                    }
                    serializable = file.getParentFile();
                    while (string2.startsWith("../")) {
                        string2 = string2.substring(3);
                        serializable = ((File)serializable).getParentFile();
                    }
                    file2 = new File((File)serializable, string2.replace('/', File.separatorChar));
                }
                serializable = extensionOwners.get(file2);
                if (serializable == null) {
                    serializable = new HashSet<File>(2);
                    serializable.add(file);
                    extensionOwners.put(file2, (Set<File>)((Object)serializable));
                } else if (!serializable.contains(file)) {
                    serializable.add(file);
                    standardModule.getManager().getEvents().log("extensionMultiplyLoaded", file2, serializable);
                }
                if (StandardModule.isModuleJar(file2)) {
                    Util.err.log(Level.WARNING, "Class-Path value {0} from {1} illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead", new Object[]{string2, file});
                }
                if (hashSet == null) {
                    hashSet = new HashSet<File>();
                }
                hashSet.add(file2);
                list = LocaleVariants.findLocaleVariantsOf(file2, this.getCodeNameBase());
                if (list.isEmpty()) continue;
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<File>();
                }
                hashSet2.addAll(list);
            }
        }
        this.localeExtensions = hashSet2;
        this.plainExtensions = hashSet;
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.log(Level.FINE, "localeVariants of {0}: {1}", new Object[]{file, this.localeVariants});
            Util.err.log(Level.FINE, "plainExtensions of {0}: {1}", new Object[]{file, this.plainExtensions});
            Util.err.log(Level.FINE, "localeExtensions of {0}: {1}", new Object[]{file, this.localeExtensions});
        }
        if ((object = extensionOwners.get(file)) != null) {
            Util.err.log(Level.WARNING, "module {0} was incorrectly placed in the Class-Path of other JARs {1}; please use OpenIDE-Module-Module-Dependencies instead", new Object[]{file, object});
        }
    }

    public StandardModuleData(ObjectInput objectInput) throws IOException {
        super(objectInput);
        this.localeVariants = StandardModuleData.readFiles(objectInput);
        this.localeExtensions = StandardModuleData.readFiles(objectInput);
        this.plainExtensions = StandardModuleData.readFiles(objectInput);
    }

    @Override
    void write(ObjectOutput objectOutput) throws IOException {
        super.write(objectOutput);
        StandardModuleData.writeFiles(objectOutput, this.localeVariants);
        StandardModuleData.writeFiles(objectOutput, this.localeExtensions);
        StandardModuleData.writeFiles(objectOutput, this.plainExtensions);
    }

    private static Set<File> readFiles(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashSet<File> hashSet = new HashSet<File>();
        while (n-- > 0) {
            hashSet.add(new File(Stamps.readRelativePath(dataInput)));
        }
        return hashSet;
    }

    private static void writeFiles(DataOutput dataOutput, Set<File> set) throws IOException {
        if (set == null) {
            dataOutput.writeInt(0);
            return;
        }
        dataOutput.writeInt(set.size());
        for (File file : set) {
            Stamps.writeRelativePath(file.getPath(), dataOutput);
        }
    }

    final void addCp(List<File> list) {
        if (this.localeVariants != null) {
            list.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            list.addAll(this.localeExtensions);
        }
        if (this.plainExtensions != null) {
            list.addAll(this.plainExtensions);
        }
    }
}

