/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.LoopNode;
import org.graalvm.visualvm.heapviewer.model.MoreNodesNode;
import org.graalvm.visualvm.heapviewer.model.NodesCache;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.ProgressNode;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class HeapViewerNode
extends CCTNode {
    public static final HeapViewerNode[] NO_NODES = new HeapViewerNode[0];
    private int indexInParent;
    private HeapViewerNode parent;
    private HeapViewerNode[] children;
    private Thread currentWorker;
    private static final Object NO_VALUE = new Object();
    private Map<DataType, Object> foreignValues;

    public final HeapViewerNode getParent() {
        return this.parent;
    }

    public HeapViewerNode getChild(int index) {
        HeapViewerNode[] ch = this.resolveChildren();
        return ch[index];
    }

    public HeapViewerNode[] getChildren() {
        return this.resolveChildren();
    }

    public int getIndexOfChild(Object child) {
        HeapViewerNode node = (HeapViewerNode)((Object)child);
        return node.getParent() == this ? node.indexInParent : -1;
    }

    public int getNChildren() {
        HeapViewerNode[] ch = this.resolveChildren();
        return ch.length;
    }

    public boolean isLeaf() {
        return this.children != null && this.getNChildren() == 0;
    }

    protected void setChildren(HeapViewerNode[] ch) {
        for (int i = 0; i < ch.length; ++i) {
            ch[i].parent = this;
            ch[i].indexInParent = i;
        }
        this.children = ch;
    }

    protected void resetChildren() {
        this.forgetChildren(null);
        this.children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetChildren(NodesCache cache) {
        HeapViewerNode[] heapViewerNodeArray = this;
        synchronized (this) {
            if (this.currentWorker != null) {
                this.currentWorker.interrupt();
                this.currentWorker = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.children != null && this.children.length > 0) {
                for (HeapViewerNode node : this.children) {
                    node.forgetChildren(cache);
                    if (cache != null) continue;
                    node.parent = null;
                }
                if (cache != null && super.childrenComputed()) {
                    cache.storeChildren((HeapViewerNode)this, this.children);
                }
                this.children = null;
            }
            return;
        }
    }

    private boolean childrenComputed() {
        if (this.children == null) {
            return false;
        }
        if (this.children.length == 0 || this.children.length > 1) {
            return true;
        }
        return !(this.children[0] instanceof ProgressNode);
    }

    private HeapViewerNode[] resolveChildren() {
        if (this.children != null) {
            return this.children;
        }
        RootNode root = RootNode.get(this);
        if (root == null) {
            return NO_NODES;
        }
        try {
            this.children = root.retrieveChildren(this);
            if (this.children == null) {
                HeapViewerNode[] ch = this.computeChildren(root);
                this.setChildren(ch == null ? NO_NODES : ch);
            }
        }
        catch (OutOfMemoryError e) {
            this.handleOOME(e);
            this.setChildren(new HeapViewerNode[]{new ErrorNode.OOME()});
        }
        return this.children;
    }

    protected HeapViewerNode[] computeChildren(final RootNode root) {
        final Progress progress = new Progress();
        SwingWorker<HeapViewerNode[], HeapViewerNode[]> worker = new SwingWorker<HeapViewerNode[], HeapViewerNode[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] doInBackground() throws Exception {
                HeapViewerNode[] ret;
                HeapViewerNode heapViewerNode = HeapViewerNode.this;
                synchronized (heapViewerNode) {
                    if (HeapViewerNode.this.currentWorker != null) {
                        HeapViewerNode.this.currentWorker.interrupt();
                    }
                    HeapViewerNode.this.currentWorker = Thread.currentThread();
                }
                try {
                    ret = HeapViewerNode.this.lazilyComputeChildren(root.getContext().getFragment().getHeap(), root.getViewID(), root.getViewFilter(), root.getDataTypes(), root.getSortOrders(), progress);
                }
                catch (InterruptedException ex) {
                    ret = null;
                }
                catch (OutOfMemoryError e) {
                    HeapViewerNode.this.handleOOME(e);
                    ret = new HeapViewerNode[]{new ErrorNode.OOME()};
                }
                if (Thread.interrupted()) {
                    ret = null;
                }
                HeapViewerNode heapViewerNode2 = HeapViewerNode.this;
                synchronized (heapViewerNode2) {
                    if (HeapViewerNode.this.currentWorker == Thread.currentThread()) {
                        HeapViewerNode.this.currentWorker = null;
                    } else {
                        ret = null;
                    }
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                HeapViewerNode heapViewerNode = HeapViewerNode.this;
                synchronized (heapViewerNode) {
                    if (HeapViewerNode.this.currentWorker == null) {
                        try {
                            HeapViewerNode[] newChildren = (HeapViewerNode[])this.get();
                            if (newChildren != null) {
                                HeapViewerNode.this.setChildren(newChildren);
                                root.updateChildren(HeapViewerNode.this);
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        };
        worker.execute();
        try {
            return (HeapViewerNode[])worker.get(UIThresholds.MODEL_CHILDREN, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (TimeoutException ex) {
            return new HeapViewerNode[]{new ProgressNode(progress)};
        }
        return null;
    }

    protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        ArrayList<HeapViewerNode> nodes = new ArrayList<HeapViewerNode>();
        RootNode root = RootNode.get(this);
        ArrayList<Provider> providers = root != null ? new ArrayList<Provider>(root.getNodeProviders()) : new ArrayList(Lookup.getDefault().lookupAll(Provider.class));
        Iterator iproviders = providers.iterator();
        while (iproviders.hasNext()) {
            if (((Provider)iproviders.next()).supportsNode(this, heap, viewID)) continue;
            iproviders.remove();
        }
        if (providers.size() == 1) {
            HeapViewerNode[] n = ((Provider)providers.iterator().next()).getNodes(this, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            if (n != null) {
                nodes.addAll(Arrays.asList(HeapViewerNode.checkForLoops(this, n)));
            }
        } else {
            for (Provider provider : providers) {
                nodes.add(new ChildrenContainer(provider));
            }
        }
        return nodes.toArray(NO_NODES);
    }

    private static HeapViewerNode[] checkForLoops(HeapViewerNode parent, HeapViewerNode[] nodes) {
        HashMap<HeapViewerNode, HeapViewerNode> pathToRoot = new HashMap<HeapViewerNode, HeapViewerNode>();
        while (parent != null) {
            pathToRoot.put(parent, parent);
            parent = parent.getParent();
        }
        for (int i = 0; i < nodes.length; ++i) {
            HeapViewerNode loopOrigin = (HeapViewerNode)((Object)pathToRoot.get((Object)nodes[i]));
            if (loopOrigin == null) continue;
            nodes[i] = new LoopNode(nodes[i], loopOrigin);
        }
        return nodes;
    }

    protected void handleOOME(OutOfMemoryError e) {
        RootNode root = RootNode.get(this);
        if (root != null) {
            root.handleOOME(e);
        } else {
            System.err.println("Out of memory in " + ((Object)((Object)this)).toString() + ": " + e.getMessage());
        }
    }

    protected <T> T getValue(DataType<T> type, Heap heap) {
        return DataType.DEFAULT_TYPES.contains(type) ? (T)type.getUnsupportedValue() : null;
    }

    public static <T> T getValue(HeapViewerNode node, DataType<T> type, Heap heap) {
        return HeapViewerNode.getValue(node, type, heap, null);
    }

    public static <T> T getValue(HeapViewerNode node, DataType<T> type, Heap heap, HeapViewerNode parent) {
        Iterator<DataType.ValueProvider> providers;
        Object value = node.getValue(type, heap);
        if (Objects.equals(value, type.getUnsupportedValue())) {
            return value;
        }
        if (value != null || type.getNoValue() == null) {
            return value;
        }
        if (!type.valuesAvailable(heap)) {
            return type.getNotAvailableValue();
        }
        if (node.foreignValues != null && (value = node.foreignValues.get(type)) != null) {
            return value == NO_VALUE ? null : (T)value;
        }
        RootNode root = RootNode.get(parent != null ? parent : node);
        Iterator<DataType.ValueProvider> iterator = providers = root != null ? root.getValueProviders().iterator() : Lookup.getDefault().lookupAll(DataType.ValueProvider.class).iterator();
        if (providers.hasNext()) {
            while (value == null && providers.hasNext()) {
                value = providers.next().getValue(node, type, heap);
            }
        }
        if (node.foreignValues == null) {
            node.foreignValues = new IdentityHashMap<DataType, Object>(1);
        }
        node.foreignValues.put(type, value == null ? NO_VALUE : value);
        return value;
    }

    public final void willBeSorted() {
        if (this.updateChildrenOnSort()) {
            this.forgetChildren(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateChildrenOnSort() {
        HeapViewerNode heapViewerNode = this;
        synchronized (heapViewerNode) {
            if (this.currentWorker != null) {
                return true;
            }
        }
        return this.children != null && this.children.length > 1 && this.children[this.children.length - 1] instanceof MoreNodesNode;
    }

    public HeapViewerNode createCopy() {
        return null;
    }

    protected void setupCopy(HeapViewerNode copy) {
    }

    public static TreePath fromNode(TreeNode node) {
        return HeapViewerNode.fromNode(node, null);
    }

    public static TreePath fromNode(TreeNode node, TreeNode root) {
        ArrayList<TreeNode> l = new ArrayList<TreeNode>();
        while (node != root) {
            l.add(0, node);
            node = node.getParent();
        }
        if (node != null) {
            l.add(0, node);
        }
        return new TreePath(l.toArray(new Object[0]));
    }

    public static abstract class Provider {
        public abstract String getName();

        public abstract boolean supportsView(Heap var1, String var2);

        public abstract boolean supportsNode(HeapViewerNode var1, Heap var2, String var3);

        public abstract HeapViewerNode[] getNodes(HeapViewerNode var1, Heap var2, String var3, HeapViewerNodeFilter var4, List<DataType> var5, List<SortOrder> var6, Progress var7) throws InterruptedException;
    }

    private static class ChildrenContainer
    extends TextNode {
        private final Provider provider;

        ChildrenContainer(Provider provider) {
            super("<" + provider.getName() + ">");
            this.resetChildren();
            this.provider = provider;
        }

        @Override
        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
            CCTNode parent = this.getParent();
            HeapViewerNode[] n = this.provider.getNodes((HeapViewerNode)parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            return n != null ? HeapViewerNode.checkForLoops((HeapViewerNode)parent, n) : NO_NODES;
        }
    }
}

