<?php declare(strict_types = 0);
/*
** Copyright (C) 2001-2026 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/


namespace Widgets\DataOver\Actions;

use CControllerDashboardWidgetView,
	CControllerResponseData;

class WidgetView extends CControllerDashboardWidgetView {

	protected function doAction(): void {
		$data = [
			'name' => $this->getInput('name', $this->widget->getDefaultName()),
			'user' => [
				'debug_mode' => $this->getDebugMode()
			],
			'is_template_dashboard' => $this->isTemplateDashboard()
		];

		// Editing template dashboard?
		if ($this->isTemplateDashboard() && !$this->fields_values['override_hostid']) {
			$data['error'] = _('No data.');
		}
		else {
			if ($this->isTemplateDashboard()) {
				$groupids = null;
				$hostids = $this->fields_values['override_hostid'];
			}
			else {
				$groupids = $this->fields_values['groupids'] ? getSubGroups($this->fields_values['groupids']) : null;
				$hostids = $this->fields_values['hostids'] ?: null;
			}

			[$items, $hosts, $has_hidden_data] = getDataOverview($groupids, $hostids, $this->fields_values);

			$data += [
				'error' => null,
				'groupids' => $groupids,
				'show_suppressed' => $this->fields_values['show_suppressed'],
				'style' => $this->fields_values['style'],
				'items' => $items,
				'hosts' => $hosts,
				'has_hidden_data' => $has_hidden_data
			];
		}

		$this->setResponse(new CControllerResponseData($data));
	}
}
