/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.complex;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.complex.MDComplexType;

public class MDEnumType
extends MDComplexType {
    private String enumTypeName;
    private String underlyingTypeName;
    private String underlyingFullTypeName;

    public MDEnumType(MDMang dmang) {
        super(dmang);
    }

    @Override
    protected void parseInternal() throws MDException {
        char code = this.dmang.getAndIncrement();
        switch (code) {
            case '0': {
                this.enumTypeName = "enum char";
                this.underlyingFullTypeName = this.underlyingTypeName = "char";
                break;
            }
            case '1': {
                this.enumTypeName = "enum unsigned char";
                this.underlyingTypeName = "char";
                this.underlyingFullTypeName = "unsigned char";
                break;
            }
            case '2': {
                this.enumTypeName = "enum short";
                this.underlyingFullTypeName = this.underlyingTypeName = "short";
                break;
            }
            case '3': {
                this.enumTypeName = "enum unsigned short";
                this.underlyingTypeName = "short";
                this.underlyingFullTypeName = "unsigned short";
                break;
            }
            case '4': {
                this.enumTypeName = "enum";
                this.underlyingFullTypeName = this.underlyingTypeName = "int";
                break;
            }
            case '5': {
                this.enumTypeName = "enum unsigned int";
                this.underlyingTypeName = "int";
                this.underlyingFullTypeName = "unsigned int";
                break;
            }
            case '6': {
                this.enumTypeName = "enum long";
                this.underlyingFullTypeName = this.underlyingTypeName = "long";
                break;
            }
            case '7': {
                this.enumTypeName = "enum unsigned long";
                this.underlyingTypeName = "long";
                this.underlyingFullTypeName = "unsigned long";
                break;
            }
            default: {
                throw new MDException("Enum code not expected: " + code);
            }
        }
        this.dmang.parseInfoPushPop(1, this.enumTypeName);
        super.parseInternal();
    }

    @Override
    public String getTypeName() {
        return this.enumTypeName;
    }

    public String getUnderlyingTypeName() {
        return this.underlyingTypeName;
    }

    public String getUnderlyingFullTypeName() {
        return this.underlyingFullTypeName;
    }
}

