/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ModulePackagesAttribute
extends AbstractAttributeInfo {
    private short package_count;
    private short[] package_index;

    protected ModulePackagesAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.package_count = reader.readNextShort();
        this.package_index = new short[this.getPackageCount()];
        for (int i = 0; i < this.getPackageCount(); i = (int)((short)(i + 1))) {
            this.package_index[i] = reader.readNextShort();
        }
    }

    public int getPackageCount() {
        return this.package_count & 0xFFFF;
    }

    public int getPackageIndexEntry(int i) {
        return this.package_index[i] & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("ModulePackages_attribute");
        structure.add(WORD, "package_count", null);
        for (int i = 0; i < this.package_index.length; ++i) {
            structure.add(WORD, "classes" + i, null);
        }
        return structure;
    }
}

