/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import docking.ActionContext;
import docking.action.DockingActionIf;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.assembler.PatchDataAction;
import ghidra.app.plugin.core.assembler.PatchInstructionAction;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Patching", shortDescription="Assembler", description="This plugin provides functionality for assembly patching. The assembler supports most processor languages also supported by the disassembler. Depending on the particular processor, your mileage may vary. We are in the process of testing and improving support for all our processors. You can access the assembler by pressing Ctrl-Shift-G, and then modifying the instruction in place. As you type, a content assist will guide you and provide assembled bytes when you have a complete instruction.")
public class AssemblerPlugin
extends ProgramPlugin {
    public static final String ASSEMBLER_NAME = "Assembler";
    PatchInstructionAction patchInstructionAction;
    PatchDataAction patchDataAction;

    public AssemblerPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        this.patchInstructionAction = new PatchInstructionAction(this, this){

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                ListingActionContext lac;
                return super.isEnabledForContext(context) && context instanceof ListingActionContext && !(lac = (ListingActionContext)context).getNavigatable().isDynamic();
            }

            @Override
            public boolean isAddToPopup(ActionContext context) {
                ListingActionContext lac;
                return super.isAddToPopup(context) && context instanceof ListingActionContext && !(lac = (ListingActionContext)context).getNavigatable().isDynamic();
            }
        };
        this.tool.addAction((DockingActionIf)this.patchInstructionAction);
        this.patchDataAction = new PatchDataAction(this, this){

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                ListingActionContext lac;
                return super.isEnabledForContext(context) && context instanceof ListingActionContext && !(lac = (ListingActionContext)context).getNavigatable().isDynamic();
            }

            @Override
            public boolean isAddToPopup(ActionContext context) {
                ListingActionContext lac;
                return super.isAddToPopup(context) && context instanceof ListingActionContext && !(lac = (ListingActionContext)context).getNavigatable().isDynamic();
            }
        };
        this.tool.addAction((DockingActionIf)this.patchDataAction);
    }

    protected void dispose() {
        this.patchInstructionAction.dispose();
        this.patchDataAction.dispose();
    }
}

