/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import ghidra.app.util.SymbolPath;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.datastruct.Duo;

public class ProgramLocationTranslator {
    private ListingAddressCorrelation correlator;

    public ProgramLocationTranslator(ListingAddressCorrelation correlator) {
        this.correlator = correlator;
    }

    public ProgramLocation getProgramLocation(Duo.Side side, ProgramLocation otherSideLocation) {
        boolean hasSymbol;
        String[] symbolPathArray;
        if (this.correlator == null) {
            return null;
        }
        if (otherSideLocation == null) {
            return null;
        }
        if (otherSideLocation instanceof VariableLocation) {
            return this.getVariableLocation(side, (VariableLocation)otherSideLocation);
        }
        SaveState saveState = new SaveState();
        otherSideLocation.saveState(saveState);
        Address otherSideAddress = otherSideLocation.getAddress();
        Address address = this.getAddress(side, otherSideAddress);
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        saveState.remove("_ADDRESS");
        saveState.putString("_ADDRESS", address.toString());
        Address byteAddress = otherSideLocation.getByteAddress();
        saveState.remove("_BYTE_ADDR");
        Address desiredByteAddress = null;
        Program program = this.correlator.getProgram(side);
        if (byteAddress != null && (desiredByteAddress = this.inferDesiredByteAddress(otherSideAddress, address, byteAddress, otherSideLocation.getProgram(), program)) != null) {
            saveState.putString("_BYTE_ADDR", desiredByteAddress.toString());
        }
        if ((symbolPathArray = saveState.getStrings("_SYMBOL_PATH", new String[0])).length != 0 && !(hasSymbol = this.adjustSymbolPath(saveState, otherSideAddress, address, byteAddress, desiredByteAddress, otherSideLocation.getProgram(), program))) {
            return new ProgramLocation(program, desiredByteAddress);
        }
        saveState.remove("_REF_ADDRESS");
        return ProgramLocation.getLocation((Program)program, (SaveState)saveState);
    }

    private Address getAddress(Duo.Side side, Address otherSidesAddress) {
        Duo.Side otherSide = side.otherSide();
        Address address = this.correlator.getAddress(side, otherSidesAddress);
        if (address != null) {
            return address;
        }
        CodeUnit otherCodeUnit = this.correlator.getProgram(otherSide).getListing().getCodeUnitContaining(otherSidesAddress);
        if (otherCodeUnit == null) {
            return null;
        }
        Address otherCodeUnitAddress = otherCodeUnit.getMinAddress();
        return this.correlator.getAddress(side, otherCodeUnitAddress);
    }

    private ProgramLocation getVariableLocation(Duo.Side side, VariableLocation variableLocation) {
        Function thunkedFunction;
        if (variableLocation == null) {
            return null;
        }
        SaveState saveState = new SaveState();
        variableLocation.saveState(saveState);
        Address address = variableLocation.getAddress();
        Address byteAddress = variableLocation.getByteAddress();
        Address functionAddress = variableLocation.getFunctionAddress();
        Address desiredAddress = this.getAddress(side, address);
        if (desiredAddress == null || desiredAddress == Address.NO_ADDRESS) {
            return null;
        }
        Address desiredByteAddress = null;
        if (byteAddress != null) {
            desiredByteAddress = this.getAddress(side, byteAddress);
        }
        Address desiredFunctionAddress = null;
        if (functionAddress != null) {
            desiredFunctionAddress = this.getAddress(side, functionAddress);
        }
        Function function = this.correlator.getFunction(side);
        if (desiredFunctionAddress == null && function != null && (thunkedFunction = function.getThunkedFunction(true)) != null) {
            desiredFunctionAddress = thunkedFunction.getEntryPoint();
        }
        saveState.remove("_ADDRESS");
        saveState.putString("_ADDRESS", desiredAddress.toString());
        saveState.remove("_BYTE_ADDR");
        if (desiredByteAddress != null) {
            saveState.putString("_BYTE_ADDR", desiredByteAddress.toString());
        }
        saveState.remove("_FUNC_ADDRESS");
        if (desiredFunctionAddress != null) {
            saveState.putString("_FUNC_ADDRESS", desiredFunctionAddress.toString());
        }
        saveState.remove("_REF_ADDRESS");
        return ProgramLocation.getLocation((Program)this.correlator.getProgram(side), (SaveState)saveState);
    }

    private boolean adjustSymbolPath(SaveState saveState, Address address, Address desiredAddress, Address byteAddress, Address desiredByteAddress, Program program, Program desiredProgram) {
        Address desiredSymbolAddress;
        saveState.remove("_SYMBOL_PATH");
        Address symbolAddress = byteAddress != null ? byteAddress : address;
        Address address2 = desiredSymbolAddress = desiredByteAddress != null ? desiredByteAddress : desiredAddress;
        if (symbolAddress == null || desiredSymbolAddress == null) {
            return false;
        }
        Symbol[] symbols = program.getSymbolTable().getSymbols(symbolAddress);
        if (symbols.length == 0) {
            return false;
        }
        Symbol[] desiredSymbols = desiredProgram.getSymbolTable().getSymbols(desiredSymbolAddress);
        if (desiredSymbols.length == 0) {
            return false;
        }
        int desiredRow = this.adjustSymbolRow(saveState, symbols, desiredSymbols);
        int desiredIndex = this.getDesiredSymbolIndex(desiredSymbols, desiredRow);
        Symbol desiredSymbol = desiredSymbols[desiredIndex];
        SymbolPath symbolPath = this.getSymbolPath(desiredSymbol);
        saveState.putStrings("_SYMBOL_PATH", symbolPath.asArray());
        return true;
    }

    private int adjustSymbolRow(SaveState saveState, Symbol[] symbols, Symbol[] desiredSymbols) {
        int row = saveState.getInt("_ROW", 0);
        int desiredRow = row;
        if (desiredRow >= desiredSymbols.length) {
            desiredRow = desiredSymbols.length - 1;
        }
        saveState.putInt("_ROW", desiredRow);
        return desiredRow;
    }

    private SymbolPath getSymbolPath(Symbol desiredSymbol) {
        String label = desiredSymbol.getName();
        Namespace namespace = desiredSymbol.getParentNamespace();
        SymbolPath symbolPath = namespace == null || namespace.isGlobal() ? new SymbolPath(label) : new SymbolPath(new SymbolPath(namespace.getSymbol()), label);
        return symbolPath;
    }

    private int getDesiredSymbolIndex(Symbol[] desiredSymbols, int desiredRow) {
        boolean hasFunction = desiredSymbols[0].getSymbolType().equals((Object)SymbolType.FUNCTION);
        int desiredIndex = 0;
        if (desiredRow >= 0 && desiredRow < desiredSymbols.length) {
            desiredIndex = desiredRow;
        }
        if (hasFunction) {
            desiredIndex = desiredIndex == desiredSymbols.length - 1 ? 0 : ++desiredIndex;
        }
        return desiredIndex;
    }

    private Address inferDesiredByteAddress(Address address, Address desiredAddress, Address byteAddress, Program program, Program desiredProgram) {
        long numBytesIntoCodeUnit = byteAddress.subtract(address);
        if (numBytesIntoCodeUnit == 0L) {
            return desiredAddress;
        }
        if (numBytesIntoCodeUnit > 0L) {
            CodeUnit codeUnit = program.getListing().getCodeUnitAt(address);
            CodeUnit desiredCodeUnit = desiredProgram.getListing().getCodeUnitAt(desiredAddress);
            if (codeUnit != null && desiredCodeUnit != null) {
                int desiredCodeUnitLength = desiredCodeUnit.getLength();
                if (numBytesIntoCodeUnit < (long)desiredCodeUnitLength) {
                    return desiredAddress.add(numBytesIntoCodeUnit);
                }
                return desiredAddress.add((long)(desiredCodeUnitLength - 1));
            }
        }
        return null;
    }
}

