/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FileSystemEventListener;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.List;

public class FileSystemRefManager {
    private GFileSystem fs;
    private List<FileSystemRef> refs = new ArrayList<FileSystemRef>();
    private ListenerSet<FileSystemEventListener> listeners = new ListenerSet(FileSystemEventListener.class, false);
    private long lastUsedTS;

    public FileSystemRefManager(GFileSystem fs) {
        this.fs = fs;
        this.touch();
    }

    private void touch() {
        this.lastUsedTS = System.currentTimeMillis();
    }

    public void addListener(FileSystemEventListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(FileSystemEventListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef create() {
        FileSystemRef ref = null;
        FileSystemRefManager fileSystemRefManager = this;
        synchronized (fileSystemRefManager) {
            if (this.fs.isClosed()) {
                throw new IllegalArgumentException("File system already closed: " + String.valueOf(this.fs));
            }
            ref = new FileSystemRef(this.fs);
            this.refs.add(ref);
            this.touch();
        }
        ((FileSystemEventListener)this.listeners.invoke()).onFilesystemRefChange(this.fs, this);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(FileSystemRef ref) {
        FileSystemRefManager fileSystemRefManager = this;
        synchronized (fileSystemRefManager) {
            for (int i = this.refs.size() - 1; i >= 0; --i) {
                FileSystemRef tmp = this.refs.get(i);
                if (tmp != ref) continue;
                this.refs.remove(i);
                this.touch();
                ref = null;
                break;
            }
        }
        if (ref != null) {
            throw new IllegalArgumentException("Tried to remove unknown reference to " + String.valueOf(this.fs));
        }
        ((FileSystemEventListener)this.listeners.invoke()).onFilesystemRefChange(this.fs, this);
    }

    public synchronized boolean canClose(FileSystemRef callersRef) {
        return this.refs.size() == 1 && this.refs.get(0) == callersRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        GFileSystem fsCopy;
        FileSystemRefManager fileSystemRefManager = this;
        synchronized (fileSystemRefManager) {
            if (this.fs == null) {
                throw new IllegalArgumentException("FileSystemRefManager already closed!");
            }
            if (!this.refs.isEmpty()) {
                Msg.warn((Object)this, (Object)("Closing filesystem even though it has active handles open: " + String.valueOf(this.fs)));
            }
            fsCopy = this.fs;
            this.fs = null;
            this.refs.clear();
            this.refs = null;
        }
        ((FileSystemEventListener)this.listeners.invoke()).onFilesystemClose(fsCopy);
    }

    public void finalize() {
        if (this.fs != null && !(this.fs instanceof GFileSystemBase)) {
            Msg.warn((Object)this, (Object)("Unclosed FilesytemRefManager for filesystem: " + String.valueOf(this.fs.getClass()) + ", " + this.fs.getName()));
        }
    }

    public synchronized long getLastUsedTimestamp() {
        return this.lastUsedTS;
    }
}

