/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.modules;

import docking.DefaultActionContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import java.util.Objects;

public class DebuggerMissingProgramActionContext
extends DefaultActionContext {
    private final Trace trace;
    private final Program program;
    private final int hashCode;
    private Address probe;

    public static Address getMappingProbeAddress(Program program) {
        if (program == null) {
            return null;
        }
        AddressIterator eepi = program.getSymbolTable().getExternalEntryPointIterator();
        if (eepi.hasNext()) {
            return eepi.next();
        }
        InstructionIterator ii = program.getListing().getInstructions(true);
        if (ii.hasNext()) {
            return ii.next().getAddress();
        }
        AddressSetView es = program.getMemory().getExecuteSet();
        if (!es.isEmpty()) {
            return es.getMinAddress();
        }
        if (!program.getMemory().isEmpty()) {
            return program.getMinAddress();
        }
        return null;
    }

    public DebuggerMissingProgramActionContext(Trace trace, Program program) {
        this.trace = Objects.requireNonNull(trace);
        this.program = Objects.requireNonNull(program);
        this.hashCode = Objects.hash(((Object)((Object)this)).getClass(), trace, program);
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Program getProgram() {
        return this.program;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebuggerMissingProgramActionContext)) {
            return false;
        }
        DebuggerMissingProgramActionContext that = (DebuggerMissingProgramActionContext)((Object)obj);
        if (!this.trace.equals((Object)that.trace)) {
            return false;
        }
        return this.program.equals((Object)that.program);
    }

    public Address getMappingProbeAddress() {
        if (this.probe == null) {
            this.probe = DebuggerMissingProgramActionContext.getMappingProbeAddress(this.program);
        }
        return this.probe;
    }
}

