/*
 * Decompiled with CFR 0.152.
 */
package sun.security.internal.spec;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

@Deprecated
public class TlsMasterSecretParameterSpec
implements AlgorithmParameterSpec {
    private final SecretKey premasterSecret;
    private final int majorVersion;
    private final int minorVersion;
    private final byte[] clientRandom;
    private final byte[] serverRandom;
    private final byte[] extendedMasterSecretSessionHash;
    private final String prfHashAlg;
    private final int prfHashLength;
    private final int prfBlockSize;

    public TlsMasterSecretParameterSpec(SecretKey secretKey, int n, int n2, byte[] byArray, byte[] byArray2, String string, int n3, int n4) {
        this(secretKey, n, n2, byArray, byArray2, new byte[0], string, n3, n4);
    }

    public TlsMasterSecretParameterSpec(SecretKey secretKey, int n, int n2, byte[] byArray, String string, int n3, int n4) {
        this(secretKey, n, n2, new byte[0], new byte[0], byArray, string, n3, n4);
    }

    private TlsMasterSecretParameterSpec(SecretKey secretKey, int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, String string, int n3, int n4) {
        if (secretKey == null) {
            throw new NullPointerException("premasterSecret must not be null");
        }
        this.premasterSecret = secretKey;
        this.majorVersion = TlsMasterSecretParameterSpec.checkVersion(n);
        this.minorVersion = TlsMasterSecretParameterSpec.checkVersion(n2);
        this.clientRandom = (byte[])byArray.clone();
        this.serverRandom = (byte[])byArray2.clone();
        this.extendedMasterSecretSessionHash = byArray3 != null ? (byte[])byArray3.clone() : new byte[]{};
        this.prfHashAlg = string;
        this.prfHashLength = n3;
        this.prfBlockSize = n4;
    }

    static int checkVersion(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Version must be between 0 and 255");
        }
        return n;
    }

    public SecretKey getPremasterSecret() {
        return this.premasterSecret;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public byte[] getClientRandom() {
        return (byte[])this.clientRandom.clone();
    }

    public byte[] getServerRandom() {
        return (byte[])this.serverRandom.clone();
    }

    public byte[] getExtendedMasterSecretSessionHash() {
        return (byte[])this.extendedMasterSecretSessionHash.clone();
    }

    public String getPRFHashAlg() {
        return this.prfHashAlg;
    }

    public int getPRFHashLength() {
        return this.prfHashLength;
    }

    public int getPRFBlockSize() {
        return this.prfBlockSize;
    }
}

