/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd.aarch64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.aarch64.AARCH64ThreadContext;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;

public final class BsdAARCH64CFrame
extends BasicCFrame {
    private static final int ADDRESS_SIZE = 8;
    private Address pc;
    private Address sp;
    private Address fp;
    private BsdDebugger dbg;

    public BsdAARCH64CFrame(BsdDebugger dbg, Address fp, Address pc) {
        super(dbg.getCDebugger());
        this.fp = fp;
        this.pc = pc;
        this.dbg = dbg;
    }

    @Override
    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.fp;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        AARCH64ThreadContext context = (AARCH64ThreadContext)thread.getContext();
        Address rsp = context.getRegisterAsAddress(31);
        if (this.fp == null || this.fp.lessThan(rsp)) {
            return null;
        }
        if (this.dbg.getAddressValue(this.fp) % 16L != 0L) {
            return null;
        }
        Address nextFP = this.fp.getAddressAt(0L);
        if (nextFP == null || nextFP.lessThanOrEqual(this.fp)) {
            return null;
        }
        Address nextPC = this.fp.getAddressAt(8L);
        if (nextPC == null) {
            return null;
        }
        return new BsdAARCH64CFrame(this.dbg, nextFP, nextPC);
    }
}

