/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.AttributeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.BootLogging;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.spi.BootstrapContext;

public class ManagedResourcesImpl
implements ManagedResources {
    private final Map<Class<? extends AttributeConverter<?, ?>>, ConverterDescriptor<?, ?>> attributeConverterDescriptorMap = new HashMap();
    private final Set<Class<?>> annotatedClassReferences = new LinkedHashSet();
    private final Set<String> annotatedClassNames = new LinkedHashSet<String>();
    private final Set<String> annotatedPackageNames = new LinkedHashSet<String>();
    private final List<Binding<? extends JaxbBindableMappingDescriptor>> mappingFileBindings = new ArrayList<Binding<? extends JaxbBindableMappingDescriptor>>();
    private Map<String, Class<?>> extraQueryImports;

    public static ManagedResourcesImpl baseline(MetadataSources sources, BootstrapContext bootstrapContext) {
        ManagedResourcesImpl managedResources = new ManagedResourcesImpl();
        bootstrapContext.getAttributeConverters().forEach(managedResources::addAttributeConverterDefinition);
        managedResources.annotatedClassReferences.addAll(sources.getAnnotatedClasses());
        managedResources.annotatedClassNames.addAll(sources.getAnnotatedClassNames());
        managedResources.annotatedPackageNames.addAll(sources.getAnnotatedPackages());
        ManagedResourcesImpl.handleXmlMappings(sources, managedResources, bootstrapContext);
        managedResources.extraQueryImports = sources.getExtraQueryImports();
        return managedResources;
    }

    private static void handleXmlMappings(MetadataSources sources, ManagedResourcesImpl impl, BootstrapContext bootstrapContext) {
        if (!bootstrapContext.getMetadataBuildingOptions().isXmlMappingEnabled()) {
            BootLogging.BOOT_LOGGER.debugf("Ignoring %s XML mappings due to `%s`", sources.getMappingXmlBindings().size(), (Object)"hibernate.xml_mapping_enabled");
            return;
        }
        impl.mappingFileBindings.addAll(sources.getXmlBindings());
    }

    @Override
    public Collection<ConverterDescriptor<?, ?>> getAttributeConverterDescriptors() {
        return Collections.unmodifiableCollection(this.attributeConverterDescriptorMap.values());
    }

    @Override
    public Collection<Class<?>> getAnnotatedClassReferences() {
        return Collections.unmodifiableSet(this.annotatedClassReferences);
    }

    @Override
    public Collection<String> getAnnotatedClassNames() {
        return Collections.unmodifiableSet(this.annotatedClassNames);
    }

    @Override
    public Collection<String> getAnnotatedPackageNames() {
        return Collections.unmodifiableSet(this.annotatedPackageNames);
    }

    @Override
    public Collection<Binding<? extends JaxbBindableMappingDescriptor>> getXmlMappingBindings() {
        return Collections.unmodifiableList(this.mappingFileBindings);
    }

    @Override
    public Map<String, Class<?>> getExtraQueryImports() {
        return this.extraQueryImports;
    }

    @Internal
    public void addAttributeConverterDefinition(ConverterDescriptor<?, ?> descriptor) {
        this.attributeConverterDescriptorMap.put(descriptor.getAttributeConverterClass(), descriptor);
    }

    @Internal
    public void addAnnotatedClassReference(Class<?> annotatedClassReference) {
        this.annotatedClassReferences.add(annotatedClassReference);
    }

    @Internal
    public void addAnnotatedClassName(String annotatedClassName) {
        this.annotatedClassNames.add(annotatedClassName);
    }

    @Internal
    public void addAnnotatedPackageName(String annotatedPackageName) {
        this.annotatedPackageNames.add(annotatedPackageName);
    }

    @Internal
    public void addXmlBinding(Binding<JaxbBindableMappingDescriptor> binding) {
        this.mappingFileBindings.add(binding);
    }
}

