/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniOnTermination;
import io.smallrye.mutiny.operators.uni.UniOnTerminationCall;
import io.smallrye.mutiny.tuples.Functions;
import java.util.function.Supplier;

public class UniOnTerminate<T> {
    private final Uni<T> upstream;

    public UniOnTerminate(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Uni<T> invoke(Functions.TriConsumer<T, Throwable, Boolean> consumer) {
        Functions.TriConsumer<T, Throwable, Boolean> actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return Infrastructure.onUniCreation(new UniOnTermination<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Uni<T> invoke(Runnable action) {
        Runnable runnable = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onUniCreation(new UniOnTermination<Object>(this.upstream, (i, f, c) -> runnable.run()));
    }

    @CheckReturnValue
    public Uni<T> call(Functions.Function3<? super T, Throwable, Boolean, Uni<?>> mapper) {
        Functions.Function3<? super T, Throwable, Boolean, Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniOnTerminationCall<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Uni<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.call((? super T i, Throwable f, Boolean c) -> (Uni)actual.get());
    }
}

