
#ifndef KPIPEWIRE_EXPORT_H
#define KPIPEWIRE_EXPORT_H

#ifdef KPIPEWIRE_STATIC_DEFINE
#  define KPIPEWIRE_EXPORT
#  define KPIPEWIRE_NO_EXPORT
#else
#  ifndef KPIPEWIRE_EXPORT
#    ifdef KPipeWire_EXPORTS
        /* We are building this library */
#      define KPIPEWIRE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KPIPEWIRE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KPIPEWIRE_NO_EXPORT
#    define KPIPEWIRE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KPIPEWIRE_DECL_DEPRECATED
#  define KPIPEWIRE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KPIPEWIRE_DECL_DEPRECATED_EXPORT
#  define KPIPEWIRE_DECL_DEPRECATED_EXPORT KPIPEWIRE_EXPORT KPIPEWIRE_DECL_DEPRECATED
#endif

#ifndef KPIPEWIRE_DECL_DEPRECATED_NO_EXPORT
#  define KPIPEWIRE_DECL_DEPRECATED_NO_EXPORT KPIPEWIRE_NO_EXPORT KPIPEWIRE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KPIPEWIRE_NO_DEPRECATED
#    define KPIPEWIRE_NO_DEPRECATED
#  endif
#endif

#define KPIPEWIRE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KPIPEWIRE_NO_DEPRECATED)
#  undef KPIPEWIRE_DEPRECATED
#  define KPIPEWIRE_DEPRECATED_EXPORT KPIPEWIRE_EXPORT
#  define KPIPEWIRE_DEPRECATED_NO_EXPORT KPIPEWIRE_NO_EXPORT
#elif defined(KPIPEWIRE_NO_DEPRECATED_WARNINGS)
#  define KPIPEWIRE_DEPRECATED
#  define KPIPEWIRE_DEPRECATED_EXPORT KPIPEWIRE_EXPORT
#  define KPIPEWIRE_DEPRECATED_NO_EXPORT KPIPEWIRE_NO_EXPORT
#else
#  define KPIPEWIRE_DEPRECATED KPIPEWIRE_DECL_DEPRECATED
#  define KPIPEWIRE_DEPRECATED_EXPORT KPIPEWIRE_DECL_DEPRECATED_EXPORT
#  define KPIPEWIRE_DEPRECATED_NO_EXPORT KPIPEWIRE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KPIPEWIRE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KPIPEWIRE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KPIPEWIRE_NO_DEPRECATED
#  define KPIPEWIRE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60505
#endif
#ifdef KPIPEWIRE_NO_DEPRECATED_WARNINGS
#  define KPIPEWIRE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KPIPEWIRE_DEPRECATED_WARNINGS_SINCE
#  ifdef KPIPEWIRE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KPIPEWIRE_DEPRECATED_WARNINGS_SINCE KPIPEWIRE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KPIPEWIRE_DEPRECATED_WARNINGS_SINCE 0x60505
#  endif
#endif

#ifndef KPIPEWIRE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KPIPEWIRE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60000
#endif

#ifdef KPIPEWIRE_DEPRECATED
#  define KPIPEWIRE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KPIPEWIRE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KPIPEWIRE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KPIPEWIRE_EXPORT_H */
