/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalParamBlock
extends Instruction {
    private LocalParamSetter[] children;

    public LocalParamBlock(LocalParamSetter[] params) {
        for (LocalParamSetter child : this.children = params) {
            this.adoptChildExpression(child);
        }
    }

    @Override
    public String getExpressionName() {
        return "block";
    }

    public LocalParamSetter[] getChildren() {
        return this.children;
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(this.children.length);
        for (LocalParamSetter e : this.children) {
            list.add(new Operand(e, OperandRole.NAVIGATE));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (replacement instanceof LocalParamSetter) {
            for (int c = 0; c < this.children.length; ++c) {
                if (this.children[c] != original) continue;
                this.children[c] = (LocalParamSetter)replacement;
                found = true;
            }
        }
        return found;
    }

    @Override
    public Expression copy() {
        LocalParamSetter[] c2 = new LocalParamSetter[this.children.length];
        for (int c = 0; c < this.children.length; ++c) {
            c2[c] = (LocalParamSetter)this.children[c].copy();
        }
        return new LocalParamBlock(c2);
    }

    @Override
    public final ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public final int getCardinality() {
        return 8192;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = (LocalParamSetter)visitor.typeCheck(this.children[c], contextInfo);
            this.adoptChildExpression(this.children[c]);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = (LocalParamSetter)visitor.optimize(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
        }
        return this;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        for (LocalParamSetter p : this.children) {
            p.getBinding().setSelectExpression(this.doPromotion(p.getBinding().getSelectExpression(), offer));
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("params");
        for (LocalParamSetter child : this.children) {
            child.explain(out);
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        for (LocalParamSetter param : this.children) {
            try {
                context.setLocalVariable(param.getBinding().getSlotNumber(), param.getBinding().getSelectValue(context));
            }
            catch (XPathException e) {
                e.maybeSetLocation(param);
                e.maybeSetContext(context);
                throw e;
            }
        }
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }
}

