/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.parser;

import java.math.BigDecimal;
import org.joda.time.Instant;
import org.logstash.filters.parser.TimestampParser;

public class UnixEpochParser
implements TimestampParser {
    private static long MAX_EPOCH_SECONDS = Integer.MAX_VALUE;

    @Override
    public Instant parse(String value) {
        if (value.contains(".")) {
            int dot = value.indexOf(".");
            long seconds = Long.parseLong(value.substring(0, dot));
            long millis = this.coerceToMillis(seconds);
            int subdigits = Math.min(3, value.length() - dot - 1);
            assert (subdigits >= 0 && subdigits <= 3);
            long subseconds = Long.parseLong(value.substring(dot + 1, dot + 1 + subdigits));
            switch (subdigits) {
                case 0: {
                    return new Instant(millis);
                }
                case 1: {
                    return new Instant(millis + subseconds * 100L);
                }
                case 2: {
                    return new Instant(millis + subseconds * 10L);
                }
            }
            return new Instant(millis + subseconds);
        }
        return new Instant(this.coerceToMillis(Long.parseLong(value)));
    }

    @Override
    public Instant parseWithTimeZone(String value, String timezone) {
        return this.parse(value);
    }

    @Override
    public Instant parse(Long value) {
        return new Instant(this.coerceToMillis(value));
    }

    @Override
    public Instant parse(Double value) {
        if (value.longValue() > MAX_EPOCH_SECONDS) {
            throw new IllegalArgumentException("Cannot parse date for value larger than UNIX epoch maximum seconds");
        }
        return new Instant((long)(value * 1000.0));
    }

    private long coerceToMillis(long value) {
        if (value > MAX_EPOCH_SECONDS) {
            throw new IllegalArgumentException("Cannot parse date for value larger than UNIX epoch maximum seconds");
        }
        return value * 1000L;
    }

    @Override
    public Instant parse(BigDecimal value) {
        if (value.longValue() > MAX_EPOCH_SECONDS) {
            throw new IllegalArgumentException("Cannot parse date for value larger than UNIX epoch maximum seconds");
        }
        return new Instant(value.scaleByPowerOfTen(3).longValue());
    }
}

