/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXAllocatorVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_allocator_interface_t")
public class BGFXAllocatorInterface
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    public BGFXAllocatorInterface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXAllocatorInterface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_allocator_vtbl_t const *")
    public BGFXAllocatorVtbl vtbl() {
        return BGFXAllocatorInterface.nvtbl(this.address());
    }

    public BGFXAllocatorInterface vtbl(@NativeType(value="bgfx_allocator_vtbl_t const *") BGFXAllocatorVtbl value) {
        BGFXAllocatorInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXAllocatorInterface set(BGFXAllocatorInterface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXAllocatorInterface malloc() {
        return (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXAllocatorInterface calloc() {
        return (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXAllocatorInterface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXAllocatorInterface create(long address) {
        return (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)address);
    }

    @Nullable
    public static BGFXAllocatorInterface createSafe(long address) {
        return address == 0L ? null : (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)address);
    }

    @Deprecated
    public static BGFXAllocatorInterface mallocStack() {
        return BGFXAllocatorInterface.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorInterface callocStack() {
        return BGFXAllocatorInterface.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorInterface mallocStack(MemoryStack stack) {
        return BGFXAllocatorInterface.malloc(stack);
    }

    @Deprecated
    public static BGFXAllocatorInterface callocStack(MemoryStack stack) {
        return BGFXAllocatorInterface.calloc(stack);
    }

    public static BGFXAllocatorInterface malloc(MemoryStack stack) {
        return (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAllocatorInterface calloc(MemoryStack stack) {
        return (BGFXAllocatorInterface)BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static BGFXAllocatorVtbl nvtbl(long struct) {
        return BGFXAllocatorVtbl.create(MemoryUtil.memGetAddress((long)(struct + (long)VTBL)));
    }

    public static void nvtbl(long struct, BGFXAllocatorVtbl value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VTBL), (long)value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress((long)(struct + (long)VTBL));
        Checks.check((long)vtbl);
        BGFXAllocatorVtbl.validate(vtbl);
    }

    static {
        Struct.Layout layout = BGFXAllocatorInterface.__struct((Struct.Member[])new Struct.Member[]{BGFXAllocatorInterface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }
}

