/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolsList
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SYMBOLS;
    public static final int LENGTH;

    public LLVMOrcCSymbolsList(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCSymbolsList.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
    public PointerBuffer Symbols() {
        return LLVMOrcCSymbolsList.nSymbols(this.address());
    }

    @NativeType(value="size_t")
    public long Length() {
        return LLVMOrcCSymbolsList.nLength(this.address());
    }

    public LLVMOrcCSymbolsList Symbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer value) {
        LLVMOrcCSymbolsList.nSymbols(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolsList set(LLVMOrcCSymbolsList src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolsList malloc() {
        return (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LLVMOrcCSymbolsList calloc() {
        return (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LLVMOrcCSymbolsList create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LLVMOrcCSymbolsList create(long address) {
        return (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)address);
    }

    @Nullable
    public static LLVMOrcCSymbolsList createSafe(long address) {
        return address == 0L ? null : (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LLVMOrcCSymbolsList.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolsList.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMOrcCSymbolsList malloc(MemoryStack stack) {
        return (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCSymbolsList calloc(MemoryStack stack) {
        return (LLVMOrcCSymbolsList)LLVMOrcCSymbolsList.wrap(LLVMOrcCSymbolsList.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOrcCSymbolsList.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nSymbols(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SYMBOLS)), (int)((int)LLVMOrcCSymbolsList.nLength(struct)));
    }

    public static long nLength(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LENGTH));
    }

    public static void nSymbols(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SYMBOLS), (long)MemoryUtil.memAddress((CustomBuffer)value));
        LLVMOrcCSymbolsList.nLength(struct, value.remaining());
    }

    public static void nLength(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LENGTH), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SYMBOLS)));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolsList.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCSymbolsList.__member((int)POINTER_SIZE), LLVMOrcCSymbolsList.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SYMBOLS = layout.offsetof(0);
        LENGTH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolsList, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolsList ELEMENT_FACTORY = LLVMOrcCSymbolsList.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOrcCSymbolsList getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
        public PointerBuffer Symbols() {
            return LLVMOrcCSymbolsList.nSymbols(this.address());
        }

        @NativeType(value="size_t")
        public long Length() {
            return LLVMOrcCSymbolsList.nLength(this.address());
        }

        public Buffer Symbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer value) {
            LLVMOrcCSymbolsList.nSymbols(this.address(), value);
            return this;
        }
    }
}

