/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.CompositorCumulativeStats;
import org.lwjgl.openvr.CompositorFrameTiming;
import org.lwjgl.openvr.CompositorStageRenderSettings;
import org.lwjgl.openvr.Compositor_BenchmarkResults;
import org.lwjgl.openvr.HmdColor;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

public class VRCompositor {
    protected VRCompositor() {
        throw new UnsupportedOperationException();
    }

    public static void VRCompositor_SetTrackingSpace(@NativeType(value="ETrackingUniverseOrigin") int eOrigin) {
        long __functionAddress = OpenVR.VRCompositor.SetTrackingSpace;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((int)eOrigin, (long)__functionAddress);
    }

    @NativeType(value="ETrackingUniverseOrigin")
    public static int VRCompositor_GetTrackingSpace() {
        long __functionAddress = OpenVR.VRCompositor.GetTrackingSpace;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress);
    }

    public static int nVRCompositor_WaitGetPoses(long pRenderPoseArray, int unRenderPoseArrayCount, long pGamePoseArray, int unGamePoseArrayCount) {
        long __functionAddress = OpenVR.VRCompositor.WaitGetPoses;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pRenderPoseArray, (int)unRenderPoseArrayCount, (long)pGamePoseArray, (int)unGamePoseArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_WaitGetPoses(@NativeType(value="TrackedDevicePose_t *") TrackedDevicePose.Buffer pRenderPoseArray, @Nullable @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose.Buffer pGamePoseArray) {
        return VRCompositor.nVRCompositor_WaitGetPoses(pRenderPoseArray.address(), pRenderPoseArray.remaining(), MemoryUtil.memAddressSafe((Pointer)pGamePoseArray), Checks.remainingSafe((CustomBuffer)pGamePoseArray));
    }

    public static int nVRCompositor_GetLastPoses(long pRenderPoseArray, int unRenderPoseArrayCount, long pGamePoseArray, int unGamePoseArrayCount) {
        long __functionAddress = OpenVR.VRCompositor.GetLastPoses;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pRenderPoseArray, (int)unRenderPoseArrayCount, (long)pGamePoseArray, (int)unGamePoseArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_GetLastPoses(@NativeType(value="TrackedDevicePose_t *") TrackedDevicePose.Buffer pRenderPoseArray, @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose.Buffer pGamePoseArray) {
        return VRCompositor.nVRCompositor_GetLastPoses(pRenderPoseArray.address(), pRenderPoseArray.remaining(), pGamePoseArray.address(), pGamePoseArray.remaining());
    }

    public static int nVRCompositor_GetLastPoseForTrackedDeviceIndex(int unDeviceIndex, long pOutputPose, long pOutputGamePose) {
        long __functionAddress = OpenVR.VRCompositor.GetLastPoseForTrackedDeviceIndex;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((int)unDeviceIndex, (long)pOutputPose, (long)pOutputGamePose, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_GetLastPoseForTrackedDeviceIndex(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @Nullable @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose pOutputPose, @Nullable @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose pOutputGamePose) {
        return VRCompositor.nVRCompositor_GetLastPoseForTrackedDeviceIndex(unDeviceIndex, MemoryUtil.memAddressSafe((Pointer)pOutputPose), MemoryUtil.memAddressSafe((Pointer)pOutputGamePose));
    }

    public static int nVRCompositor_Submit(int eEye, long pTexture, long pBounds, int nSubmitFlags) {
        long __functionAddress = OpenVR.VRCompositor.Submit;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Texture.validate(pTexture);
        }
        return JNI.callPPI((int)eEye, (long)pTexture, (long)pBounds, (int)nSubmitFlags, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_Submit(@NativeType(value="EVREye") int eEye, @NativeType(value="Texture_t const *") Texture pTexture, @Nullable @NativeType(value="VRTextureBounds_t const *") VRTextureBounds pBounds, @NativeType(value="EVRSubmitFlags") int nSubmitFlags) {
        return VRCompositor.nVRCompositor_Submit(eEye, pTexture.address(), MemoryUtil.memAddressSafe((Pointer)pBounds), nSubmitFlags);
    }

    public static void VRCompositor_ClearLastSubmittedFrame() {
        long __functionAddress = OpenVR.VRCompositor.ClearLastSubmittedFrame;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void VRCompositor_PostPresentHandoff() {
        long __functionAddress = OpenVR.VRCompositor.PostPresentHandoff;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static boolean nVRCompositor_GetFrameTiming(long pTiming, int unFramesAgo) {
        long __functionAddress = OpenVR.VRCompositor.GetFrameTiming;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPZ((long)pTiming, (int)unFramesAgo, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_GetFrameTiming(@NativeType(value="Compositor_FrameTiming *") CompositorFrameTiming.Buffer pTiming) {
        return VRCompositor.nVRCompositor_GetFrameTiming(pTiming.address(), pTiming.remaining());
    }

    public static int nVRCompositor_GetFrameTimings(long pTiming, int nFrames) {
        long __functionAddress = OpenVR.VRCompositor.GetFrameTimings;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)pTiming, (int)nFrames, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRCompositor_GetFrameTimings(@NativeType(value="Compositor_FrameTiming *") CompositorFrameTiming.Buffer pTiming) {
        return VRCompositor.nVRCompositor_GetFrameTimings(pTiming.address(), pTiming.remaining());
    }

    public static float VRCompositor_GetFrameTimeRemaining() {
        long __functionAddress = OpenVR.VRCompositor.GetFrameTimeRemaining;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callF((long)__functionAddress);
    }

    public static void nVRCompositor_GetCumulativeStats(long pStats, int nStatsSizeInBytes) {
        long __functionAddress = OpenVR.VRCompositor.GetCumulativeStats;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)pStats, (int)nStatsSizeInBytes, (long)__functionAddress);
    }

    public static void VRCompositor_GetCumulativeStats(@NativeType(value="Compositor_CumulativeStats *") CompositorCumulativeStats pStats, @NativeType(value="uint32_t") int nStatsSizeInBytes) {
        VRCompositor.nVRCompositor_GetCumulativeStats(pStats.address(), nStatsSizeInBytes);
    }

    public static void VRCompositor_GetCumulativeStats(@NativeType(value="Compositor_CumulativeStats *") CompositorCumulativeStats pStats) {
        VRCompositor.nVRCompositor_GetCumulativeStats(pStats.address(), CompositorCumulativeStats.SIZEOF);
    }

    public static void VRCompositor_FadeToColor(float fSeconds, float fRed, float fGreen, float fBlue, float fAlpha, @NativeType(value="bool") boolean bBackground) {
        long __functionAddress = OpenVR.VRCompositor.FadeToColor;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((float)fSeconds, (float)fRed, (float)fGreen, (float)fBlue, (float)fAlpha, (boolean)bBackground, (long)__functionAddress);
    }

    public static native void nVRCompositor_GetCurrentFadeColor(boolean var0, long var1, long var3);

    public static void nVRCompositor_GetCurrentFadeColor(boolean bBackground, long __result) {
        long __functionAddress = OpenVR.VRCompositor.GetCurrentFadeColor;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        VRCompositor.nVRCompositor_GetCurrentFadeColor(bBackground, __functionAddress, __result);
    }

    @NativeType(value="HmdColor_t")
    public static HmdColor VRCompositor_GetCurrentFadeColor(@NativeType(value="bool") boolean bBackground, @NativeType(value="HmdColor_t") HmdColor __result) {
        VRCompositor.nVRCompositor_GetCurrentFadeColor(bBackground, __result.address());
        return __result;
    }

    public static void VRCompositor_FadeGrid(float fSeconds, @NativeType(value="bool") boolean bFadeGridIn) {
        long __functionAddress = OpenVR.VRCompositor.FadeGrid;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((float)fSeconds, (boolean)bFadeGridIn, (long)__functionAddress);
    }

    public static float VRCompositor_GetCurrentGridAlpha() {
        long __functionAddress = OpenVR.VRCompositor.GetCurrentGridAlpha;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callF((long)__functionAddress);
    }

    public static int nVRCompositor_SetSkyboxOverride(long pTextures, int unTextureCount) {
        long __functionAddress = OpenVR.VRCompositor.SetSkyboxOverride;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Struct.validate((long)pTextures, (int)unTextureCount, (int)Texture.SIZEOF, Texture::validate);
        }
        return JNI.callPI((long)pTextures, (int)unTextureCount, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_SetSkyboxOverride(@NativeType(value="Texture_t const *") Texture.Buffer pTextures) {
        return VRCompositor.nVRCompositor_SetSkyboxOverride(pTextures.address(), pTextures.remaining());
    }

    public static void VRCompositor_ClearSkyboxOverride() {
        long __functionAddress = OpenVR.VRCompositor.ClearSkyboxOverride;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void VRCompositor_CompositorBringToFront() {
        long __functionAddress = OpenVR.VRCompositor.CompositorBringToFront;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void VRCompositor_CompositorGoToBack() {
        long __functionAddress = OpenVR.VRCompositor.CompositorGoToBack;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void VRCompositor_CompositorQuit() {
        long __functionAddress = OpenVR.VRCompositor.CompositorQuit;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_IsFullscreen() {
        long __functionAddress = OpenVR.VRCompositor.IsFullscreen;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRCompositor_GetCurrentSceneFocusProcess() {
        long __functionAddress = OpenVR.VRCompositor.GetCurrentSceneFocusProcess;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRCompositor_GetLastFrameRenderer() {
        long __functionAddress = OpenVR.VRCompositor.GetLastFrameRenderer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_CanRenderScene() {
        long __functionAddress = OpenVR.VRCompositor.CanRenderScene;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    public static void VRCompositor_ShowMirrorWindow() {
        long __functionAddress = OpenVR.VRCompositor.ShowMirrorWindow;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void VRCompositor_HideMirrorWindow() {
        long __functionAddress = OpenVR.VRCompositor.HideMirrorWindow;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_IsMirrorWindowVisible() {
        long __functionAddress = OpenVR.VRCompositor.IsMirrorWindowVisible;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    public static void VRCompositor_CompositorDumpImages() {
        long __functionAddress = OpenVR.VRCompositor.CompositorDumpImages;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_ShouldAppRenderWithLowResources() {
        long __functionAddress = OpenVR.VRCompositor.ShouldAppRenderWithLowResources;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    public static void VRCompositor_ForceInterleavedReprojectionOn(@NativeType(value="bool") boolean bOverride) {
        long __functionAddress = OpenVR.VRCompositor.ForceInterleavedReprojectionOn;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((boolean)bOverride, (long)__functionAddress);
    }

    public static void VRCompositor_ForceReconnectProcess() {
        long __functionAddress = OpenVR.VRCompositor.ForceReconnectProcess;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static void VRCompositor_SuspendRendering(@NativeType(value="bool") boolean bSuspend) {
        long __functionAddress = OpenVR.VRCompositor.SuspendRendering;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((boolean)bSuspend, (long)__functionAddress);
    }

    public static int nVRCompositor_GetMirrorTextureD3D11(int eEye, long pD3D11DeviceOrResource, long ppD3D11ShaderResourceView) {
        long __functionAddress = OpenVR.VRCompositor.GetMirrorTextureD3D11;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pD3D11DeviceOrResource);
        }
        return JNI.callPPI((int)eEye, (long)pD3D11DeviceOrResource, (long)ppD3D11ShaderResourceView, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_GetMirrorTextureD3D11(@NativeType(value="EVREye") int eEye, @NativeType(value="void *") long pD3D11DeviceOrResource, @NativeType(value="void **") PointerBuffer ppD3D11ShaderResourceView) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ppD3D11ShaderResourceView, (int)1);
        }
        return VRCompositor.nVRCompositor_GetMirrorTextureD3D11(eEye, pD3D11DeviceOrResource, MemoryUtil.memAddress((CustomBuffer)ppD3D11ShaderResourceView));
    }

    public static void VRCompositor_ReleaseMirrorTextureD3D11(@NativeType(value="void *") long pD3D11ShaderResourceView) {
        long __functionAddress = OpenVR.VRCompositor.ReleaseMirrorTextureD3D11;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pD3D11ShaderResourceView);
        }
        JNI.callPV((long)pD3D11ShaderResourceView, (long)__functionAddress);
    }

    public static int nVRCompositor_GetMirrorTextureGL(int eEye, long pglTextureId, long pglSharedTextureHandle) {
        long __functionAddress = OpenVR.VRCompositor.GetMirrorTextureGL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((int)eEye, (long)pglTextureId, (long)pglSharedTextureHandle, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_GetMirrorTextureGL(@NativeType(value="EVREye") int eEye, @NativeType(value="glUInt_t *") IntBuffer pglTextureId, @NativeType(value="glSharedTextureHandle_t *") PointerBuffer pglSharedTextureHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pglTextureId, (int)1);
            Checks.check((CustomBuffer)pglSharedTextureHandle, (int)1);
        }
        return VRCompositor.nVRCompositor_GetMirrorTextureGL(eEye, MemoryUtil.memAddress((IntBuffer)pglTextureId), MemoryUtil.memAddress((CustomBuffer)pglSharedTextureHandle));
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_ReleaseSharedGLTexture(@NativeType(value="glUInt_t") int glTextureId, @NativeType(value="glSharedTextureHandle_t") long glSharedTextureHandle) {
        long __functionAddress = OpenVR.VRCompositor.ReleaseSharedGLTexture;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)glSharedTextureHandle);
        }
        return JNI.callPZ((int)glTextureId, (long)glSharedTextureHandle, (long)__functionAddress);
    }

    public static void VRCompositor_LockGLSharedTextureForAccess(@NativeType(value="glSharedTextureHandle_t") long glSharedTextureHandle) {
        long __functionAddress = OpenVR.VRCompositor.LockGLSharedTextureForAccess;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)glSharedTextureHandle);
        }
        JNI.callPV((long)glSharedTextureHandle, (long)__functionAddress);
    }

    public static void VRCompositor_UnlockGLSharedTextureForAccess(@NativeType(value="glSharedTextureHandle_t") long glSharedTextureHandle) {
        long __functionAddress = OpenVR.VRCompositor.UnlockGLSharedTextureForAccess;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)glSharedTextureHandle);
        }
        JNI.callPV((long)glSharedTextureHandle, (long)__functionAddress);
    }

    public static int nVRCompositor_GetVulkanInstanceExtensionsRequired(long pchValue, int unBufferSize) {
        long __functionAddress = OpenVR.VRCompositor.GetVulkanInstanceExtensionsRequired;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)pchValue, (int)unBufferSize, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRCompositor_GetVulkanInstanceExtensionsRequired(@Nullable @NativeType(value="char *") ByteBuffer pchValue) {
        return VRCompositor.nVRCompositor_GetVulkanInstanceExtensionsRequired(MemoryUtil.memAddressSafe((ByteBuffer)pchValue), Checks.remainingSafe((Buffer)pchValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRCompositor_GetVulkanInstanceExtensionsRequired(@NativeType(value="uint32_t") int unBufferSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchValue = stack.malloc(unBufferSize);
            int __result = VRCompositor.nVRCompositor_GetVulkanInstanceExtensionsRequired(MemoryUtil.memAddress((ByteBuffer)pchValue), unBufferSize);
            String string = MemoryUtil.memASCII((ByteBuffer)pchValue, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRCompositor_GetVulkanDeviceExtensionsRequired(long pPhysicalDevice, long pchValue, int unBufferSize) {
        long __functionAddress = OpenVR.VRCompositor.GetVulkanDeviceExtensionsRequired;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pPhysicalDevice);
        }
        return JNI.callPPI((long)pPhysicalDevice, (long)pchValue, (int)unBufferSize, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRCompositor_GetVulkanDeviceExtensionsRequired(@NativeType(value="VkPhysicalDevice_T *") long pPhysicalDevice, @Nullable @NativeType(value="char *") ByteBuffer pchValue) {
        return VRCompositor.nVRCompositor_GetVulkanDeviceExtensionsRequired(pPhysicalDevice, MemoryUtil.memAddressSafe((ByteBuffer)pchValue), Checks.remainingSafe((Buffer)pchValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRCompositor_GetVulkanDeviceExtensionsRequired(@NativeType(value="VkPhysicalDevice_T *") long pPhysicalDevice, @NativeType(value="uint32_t") int unBufferSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchValue = stack.malloc(unBufferSize);
            int __result = VRCompositor.nVRCompositor_GetVulkanDeviceExtensionsRequired(pPhysicalDevice, MemoryUtil.memAddress((ByteBuffer)pchValue), unBufferSize);
            String string = MemoryUtil.memASCII((ByteBuffer)pchValue, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void VRCompositor_SetExplicitTimingMode(@NativeType(value="EVRCompositorTimingMode") int eTimingMode) {
        long __functionAddress = OpenVR.VRCompositor.SetExplicitTimingMode;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((int)eTimingMode, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_SubmitExplicitTimingData() {
        long __functionAddress = OpenVR.VRCompositor.SubmitExplicitTimingData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_IsMotionSmoothingEnabled() {
        long __functionAddress = OpenVR.VRCompositor.IsMotionSmoothingEnabled;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_IsMotionSmoothingSupported() {
        long __functionAddress = OpenVR.VRCompositor.IsMotionSmoothingSupported;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_IsCurrentSceneFocusAppLoading() {
        long __functionAddress = OpenVR.VRCompositor.IsCurrentSceneFocusAppLoading;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    public static int nVRCompositor_SetStageOverride_Async(long pchRenderModelPath, long pTransform, long pRenderSettings, int nSizeOfRenderSettings) {
        long __functionAddress = OpenVR.VRCompositor.SetStageOverride_Async;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pchRenderModelPath, (long)pTransform, (long)pRenderSettings, (int)nSizeOfRenderSettings, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_SetStageOverride_Async(@NativeType(value="char const *") ByteBuffer pchRenderModelPath, @NativeType(value="HmdMatrix34_t const *") HmdMatrix34 pTransform, @NativeType(value="Compositor_StageRenderSettings const *") CompositorStageRenderSettings pRenderSettings, @NativeType(value="uint32_t") int nSizeOfRenderSettings) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelPath);
        }
        return VRCompositor.nVRCompositor_SetStageOverride_Async(MemoryUtil.memAddress((ByteBuffer)pchRenderModelPath), pTransform.address(), pRenderSettings.address(), nSizeOfRenderSettings);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_SetStageOverride_Async(@NativeType(value="char const *") ByteBuffer pchRenderModelPath, @NativeType(value="HmdMatrix34_t const *") HmdMatrix34 pTransform, @NativeType(value="Compositor_StageRenderSettings const *") CompositorStageRenderSettings pRenderSettings) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelPath);
        }
        return VRCompositor.nVRCompositor_SetStageOverride_Async(MemoryUtil.memAddress((ByteBuffer)pchRenderModelPath), pTransform.address(), pRenderSettings.address(), CompositorStageRenderSettings.SIZEOF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_SetStageOverride_Async(@NativeType(value="char const *") CharSequence pchRenderModelPath, @NativeType(value="HmdMatrix34_t const *") HmdMatrix34 pTransform, @NativeType(value="Compositor_StageRenderSettings const *") CompositorStageRenderSettings pRenderSettings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelPath, true);
            long pchRenderModelPathEncoded = stack.getPointerAddress();
            int n = VRCompositor.nVRCompositor_SetStageOverride_Async(pchRenderModelPathEncoded, pTransform.address(), pRenderSettings.address(), CompositorStageRenderSettings.SIZEOF);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void VRCompositor_ClearStageOverride() {
        long __functionAddress = OpenVR.VRCompositor.ClearStageOverride;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static boolean nVRCompositor_GetCompositorBenchmarkResults(long pBenchmarkResults, int nSizeOfBenchmarkResults) {
        long __functionAddress = OpenVR.VRCompositor.GetCompositorBenchmarkResults;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPZ((long)pBenchmarkResults, (int)nSizeOfBenchmarkResults, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRCompositor_GetCompositorBenchmarkResults(@NativeType(value="Compositor_BenchmarkResults *") Compositor_BenchmarkResults.Buffer pBenchmarkResults) {
        return VRCompositor.nVRCompositor_GetCompositorBenchmarkResults(pBenchmarkResults.address(), pBenchmarkResults.remaining());
    }

    public static int nVRCompositor_GetLastPosePredictionIDs(long pRenderPosePredictionID, long pGamePosePredictionID) {
        long __functionAddress = OpenVR.VRCompositor.GetLastPosePredictionIDs;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pRenderPosePredictionID, (long)pGamePosePredictionID, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_GetLastPosePredictionIDs(@NativeType(value="uint32_t *") IntBuffer pRenderPosePredictionID, @NativeType(value="uint32_t *") IntBuffer pGamePosePredictionID) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pRenderPosePredictionID, (int)1);
            Checks.check((Buffer)pGamePosePredictionID, (int)1);
        }
        return VRCompositor.nVRCompositor_GetLastPosePredictionIDs(MemoryUtil.memAddress((IntBuffer)pRenderPosePredictionID), MemoryUtil.memAddress((IntBuffer)pGamePosePredictionID));
    }

    public static int nVRCompositor_GetPosesForFrame(int unPosePredictionID, long pPoseArray, int unPoseArrayCount) {
        long __functionAddress = OpenVR.VRCompositor.GetPosesForFrame;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((int)unPosePredictionID, (long)pPoseArray, (int)unPoseArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRCompositorError")
    public static int VRCompositor_GetPosesForFrame(@NativeType(value="uint32_t") int unPosePredictionID, @NativeType(value="TrackedDevicePose_t *") TrackedDevicePose.Buffer pPoseArray) {
        return VRCompositor.nVRCompositor_GetPosesForFrame(unPosePredictionID, pPoseArray.address(), pPoseArray.remaining());
    }

    static {
        OpenVR.initialize();
    }
}

