/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import org.apache.lucene.search.DoubleValuesSource;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.script.expression.CountMethodValueSource;
import org.opensearch.script.expression.EmptyMemberValueSource;
import org.opensearch.script.expression.FieldDataValueSource;
import org.opensearch.search.MultiValueMode;

final class NumericField {
    static final String VALUE_VARIABLE = "value";
    static final String EMPTY_VARIABLE = "empty";
    static final String LENGTH_VARIABLE = "length";
    static final String GETVALUE_METHOD = "getValue";
    static final String ISEMPTY_METHOD = "isEmpty";
    static final String SIZE_METHOD = "size";
    static final String MINIMUM_METHOD = "min";
    static final String MAXIMUM_METHOD = "max";
    static final String AVERAGE_METHOD = "avg";
    static final String MEDIAN_METHOD = "median";
    static final String SUM_METHOD = "sum";
    static final String COUNT_METHOD = "count";

    private NumericField() {
    }

    static DoubleValuesSource getVariable(IndexFieldData<?> fieldData, String fieldName, String variable) {
        switch (variable) {
            case "value": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "empty": {
                return new EmptyMemberValueSource(fieldData);
            }
            case "length": {
                return new CountMethodValueSource(fieldData);
            }
        }
        throw new IllegalArgumentException("Member variable [" + variable + "] does not exist for numeric field [" + fieldName + "].");
    }

    static DoubleValuesSource getMethod(IndexFieldData<?> fieldData, String fieldName, String method) {
        switch (method) {
            case "getValue": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "isEmpty": {
                return new EmptyMemberValueSource(fieldData);
            }
            case "size": {
                return new CountMethodValueSource(fieldData);
            }
            case "min": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "max": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MAX);
            }
            case "avg": {
                return new FieldDataValueSource(fieldData, MultiValueMode.AVG);
            }
            case "median": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MEDIAN);
            }
            case "sum": {
                return new FieldDataValueSource(fieldData, MultiValueMode.SUM);
            }
            case "count": {
                return new CountMethodValueSource(fieldData);
            }
        }
        throw new IllegalArgumentException("Member method [" + method + "] does not exist for numeric field [" + fieldName + "].");
    }
}

