/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.searchrelevance.metrics.calculator.PairComparison;

public class PairwiseComparisonMetrics {
    private static void addMetric(List<Map<String, Object>> metrics, String metricName, double value) {
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("metric", metricName);
        metric.put("value", value);
        metrics.add(metric);
    }

    public static List<Map<String, Object>> calculatePairwiseMetrics(Map<String, List<String>> indexToDocIdMap) {
        ArrayList<Map<String, Object>> pairwiseMetrics = new ArrayList<Map<String, Object>>();
        List<String> docIdListA = indexToDocIdMap.get("0");
        List<String> docIdListB = indexToDocIdMap.get("1");
        PairwiseComparisonMetrics.addMetric(pairwiseMetrics, "jaccard", PairComparison.calculateJaccardSimilarity(docIdListA, docIdListB));
        PairwiseComparisonMetrics.addMetric(pairwiseMetrics, "rbo50", PairComparison.calculateRBOSimilarity(docIdListA, docIdListB, 0.5));
        PairwiseComparisonMetrics.addMetric(pairwiseMetrics, "rbo90", PairComparison.calculateRBOSimilarity(docIdListA, docIdListB, 0.9));
        PairwiseComparisonMetrics.addMetric(pairwiseMetrics, "frequencyWeighted", PairComparison.calculateFrequencyWeightedSimilarity(docIdListA, docIdListB));
        return pairwiseMetrics;
    }
}

