/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class WildcardMatcher
implements Predicate<String> {
    public static final WildcardMatcher ANY = new WildcardMatcher(){

        @Override
        public boolean matchAny(Stream<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAny(Collection<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAny(String ... candidates) {
            return true;
        }

        @Override
        public boolean matchAll(Stream<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAll(Collection<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAll(String ... candidates) {
            return true;
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(Stream<String> candidates, Collector<String, ?, T> collector) {
            return (T)((Collection)candidates.collect(collector));
        }

        @Override
        public boolean test(String candidate) {
            return true;
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return this;
        }

        public String toString() {
            return "*";
        }
    };
    public static final WildcardMatcher NONE = new WildcardMatcher(){

        @Override
        public boolean matchAny(Stream<String> candidates) {
            return false;
        }

        @Override
        public boolean matchAny(Collection<String> candidates) {
            return false;
        }

        @Override
        public boolean matchAny(String ... candidates) {
            return false;
        }

        @Override
        public boolean matchAll(Stream<String> candidates) {
            return candidates.findAny().isEmpty();
        }

        @Override
        public boolean matchAll(Collection<String> candidates) {
            return candidates.isEmpty();
        }

        @Override
        public boolean matchAll(String ... candidates) {
            return candidates.length == 0;
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(Stream<String> candidates, Collector<String, ?, T> collector) {
            return (T)((Collection)Stream.empty().collect(collector));
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(Collection<String> candidate, Collector<String, ?, T> collector) {
            return (T)((Collection)Stream.empty().collect(collector));
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(String[] candidate, Collector<String, ?, T> collector) {
            return (T)((Collection)Stream.empty().collect(collector));
        }

        @Override
        public boolean test(String candidate) {
            return false;
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return this;
        }

        public String toString() {
            return "<NONE>";
        }
    };

    public static WildcardMatcher from(String pattern) {
        if (pattern == null || pattern.isBlank()) {
            return NONE;
        }
        if (pattern.equals("*")) {
            return ANY;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return new RegexMatcher(pattern, true);
        }
        int star = pattern.indexOf(42);
        int questionmark = pattern.indexOf(63);
        if (star == -1 && questionmark == -1) {
            return new Exact(pattern, true);
        }
        if (star == pattern.length() - 1 && questionmark == -1) {
            return new PrefixMatcher(pattern, true);
        }
        if (pattern.length() > 1 && questionmark == -1 && star == 0 && pattern.indexOf(42, 1) == pattern.length() - 1) {
            return new ContainsMatcher(pattern, true);
        }
        return new SimpleMatcher(pattern);
    }

    public static <T> WildcardMatcher from(Stream<T> stream) {
        Collection matchers = (Collection)stream.map(t -> {
            if (t == null) {
                return NONE;
            }
            if (t instanceof String) {
                return WildcardMatcher.from((String)t);
            }
            if (t instanceof WildcardMatcher) {
                return (WildcardMatcher)t;
            }
            throw new UnsupportedOperationException("WildcardMatcher can't be constructed from " + t.getClass().getSimpleName());
        }).collect(ImmutableSet.toImmutableSet());
        if (matchers.isEmpty()) {
            return NONE;
        }
        if (matchers.size() == 1) {
            return (WildcardMatcher)matchers.stream().findFirst().get();
        }
        return new MatcherCombiner(matchers);
    }

    public static <T> WildcardMatcher from(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return NONE;
        }
        if (collection.size() == 1) {
            T t = collection.stream().findFirst().get();
            if (t instanceof String) {
                return WildcardMatcher.from((String)t);
            }
            if (t instanceof WildcardMatcher) {
                return (WildcardMatcher)t;
            }
            throw new UnsupportedOperationException("WildcardMatcher can't be constructed from " + t.getClass().getSimpleName());
        }
        return WildcardMatcher.from(collection.stream());
    }

    public static WildcardMatcher from(String ... patterns) {
        if (patterns == null || patterns.length == 0) {
            return NONE;
        }
        if (patterns.length == 1) {
            return WildcardMatcher.from(patterns[0]);
        }
        return WildcardMatcher.from(Arrays.stream(patterns));
    }

    @Override
    public abstract boolean test(String var1);

    public abstract WildcardMatcher ignoreCase();

    public WildcardMatcher concat(Collection<WildcardMatcher> matchers) {
        if (matchers.isEmpty()) {
            return this;
        }
        return new MatcherCombiner((Collection)Stream.concat(matchers.stream(), Stream.of(this)).collect(ImmutableSet.toImmutableSet()));
    }

    public boolean matchAny(Stream<String> candidates) {
        return candidates.anyMatch(this);
    }

    public boolean matchAny(Collection<String> candidates) {
        return this.matchAny(candidates.stream());
    }

    public boolean matchAny(String ... candidates) {
        return this.matchAny(Arrays.stream(candidates));
    }

    public boolean matchAll(Stream<String> candidates) {
        return candidates.allMatch(this);
    }

    public boolean matchAll(Collection<String> candidates) {
        return this.matchAll(candidates.stream());
    }

    public boolean matchAll(String ... candidates) {
        return this.matchAll(Arrays.stream(candidates));
    }

    public <T extends Collection<String>> T getMatchAny(Stream<String> candidates, Collector<String, ?, T> collector) {
        return (T)((Collection)candidates.filter(this).collect(collector));
    }

    public <T extends Collection<String>> T getMatchAny(Collection<String> candidate, Collector<String, ?, T> collector) {
        return this.getMatchAny(candidate.stream(), collector);
    }

    public <T extends Collection<String>> T getMatchAny(String[] candidate, Collector<String, ?, T> collector) {
        return this.getMatchAny(Arrays.stream(candidate), collector);
    }

    public Iterable<String> iterateMatching(Iterable<String> candidates) {
        return this.iterateMatching(candidates, Function.identity());
    }

    public <E> Iterable<E> iterateMatching(final Iterable<E> candidates, final Function<E, String> toStringFunction) {
        return new Iterable<E>(){
            final /* synthetic */ WildcardMatcher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<E> iterator() {
                final Iterator delegate = candidates.iterator();
                return new Iterator<E>(){
                    private E next;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.init();
                        }
                        return this.next != null;
                    }

                    @Override
                    public E next() {
                        if (this.next == null) {
                            this.init();
                        }
                        Object result = this.next;
                        this.next = null;
                        return result;
                    }

                    private void init() {
                        while (delegate.hasNext()) {
                            Object candidate = delegate.next();
                            if (!this.this$1.this$0.test((String)toStringFunction.apply(candidate))) continue;
                            this.next = candidate;
                            break;
                        }
                    }
                };
            }
        };
    }

    public List<String> matching(Collection<String> candidates) {
        return this.matching(candidates, Function.identity());
    }

    public <E> List<E> matching(Collection<E> candidates, Function<E, String> toStringFunction) {
        ArrayList<E> result = new ArrayList<E>(Math.min(candidates.size(), 20));
        for (E candidate : candidates) {
            if (!this.test(toStringFunction.apply(candidate))) continue;
            result.add(candidate);
        }
        return result;
    }

    public static List<WildcardMatcher> matchers(Collection<String> patterns) {
        return patterns.stream().map(WildcardMatcher::from).collect(Collectors.toList());
    }

    public static List<String> getAllMatchingPatterns(Collection<WildcardMatcher> matchers, String candidate) {
        return matchers.stream().filter(p -> p.test(candidate)).map(Objects::toString).collect(Collectors.toList());
    }

    public static List<String> getAllMatchingPatterns(Collection<WildcardMatcher> pattern, Collection<String> candidates) {
        return pattern.stream().filter(p -> p.matchAny(candidates)).map(Objects::toString).collect(Collectors.toList());
    }

    public static boolean isExact(String pattern) {
        return pattern == null || !pattern.contains("*") && !pattern.contains("?") && (!pattern.startsWith("/") || !pattern.endsWith("/"));
    }

    static final class RegexMatcher
    extends AbstractSimpleWildcardMatcher {
        private final Pattern pattern;

        private RegexMatcher(String pattern, boolean caseSensitive) {
            super(pattern);
            Preconditions.checkArgument((pattern.length() > 1 && pattern.startsWith("/") && pattern.endsWith("/") ? 1 : 0) != 0);
            String stripSlashesPattern = pattern.substring(1, pattern.length() - 1);
            this.pattern = caseSensitive ? Pattern.compile(stripSlashesPattern) : Pattern.compile(stripSlashesPattern, 2);
        }

        @Override
        public boolean test(String candidate) {
            return this.pattern.matcher(candidate).matches();
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return new RegexMatcher(((AbstractSimpleWildcardMatcher)this).pattern, false);
        }
    }

    static final class Exact
    extends AbstractSimpleWildcardMatcher {
        private final boolean caseSensitive;

        private Exact(String pattern, boolean caseSensitive) {
            super(pattern);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean test(String candidate) {
            if (this.caseSensitive) {
                return this.pattern.equals(candidate);
            }
            return this.pattern.equalsIgnoreCase(candidate);
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return new Exact(this.pattern, false);
        }
    }

    static final class PrefixMatcher
    extends AbstractSimpleWildcardMatcher {
        private final String prefix;
        private final boolean caseSensitive;

        PrefixMatcher(String pattern, boolean caseSensitive) {
            super(pattern);
            assert (pattern.endsWith("*"));
            this.prefix = pattern.substring(0, pattern.length() - 1);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean test(String s) {
            if (this.caseSensitive) {
                return s.startsWith(this.prefix);
            }
            return StringUtils.startsWithIgnoreCase((CharSequence)s, (CharSequence)this.prefix);
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return new PrefixMatcher(this.pattern, false);
        }
    }

    static final class ContainsMatcher
    extends AbstractSimpleWildcardMatcher {
        private final String string;
        private final boolean caseSensitive;

        ContainsMatcher(String pattern, boolean caseSensitive) {
            super(pattern);
            assert (pattern.endsWith("*") && pattern.startsWith("*"));
            this.string = pattern.substring(1, pattern.length() - 1);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean test(String s) {
            if (this.caseSensitive) {
                return s.contains(this.string);
            }
            return StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)this.string);
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return new ContainsMatcher(this.pattern, false);
        }
    }

    static class SimpleMatcher
    extends AbstractSimpleWildcardMatcher {
        SimpleMatcher(String pattern) {
            super(pattern);
        }

        @Override
        public boolean test(String candidate) {
            int i = 0;
            int j = 0;
            int n = candidate.length();
            int m = this.pattern.length();
            int text_backup = -1;
            int wild_backup = -1;
            while (i < n) {
                if (j < m && this.pattern.charAt(j) == '*') {
                    text_backup = i;
                    wild_backup = ++j;
                    continue;
                }
                if (j < m && (this.pattern.charAt(j) == '?' || this.pattern.charAt(j) == candidate.charAt(i))) {
                    ++i;
                    ++j;
                    continue;
                }
                if (wild_backup == -1) {
                    return false;
                }
                i = ++text_backup;
                j = wild_backup;
            }
            while (j < m && this.pattern.charAt(j) == '*') {
                ++j;
            }
            return j >= m;
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return new SimpleMatcher(this, this.pattern.toLowerCase()){

                @Override
                public boolean test(String candidate) {
                    return super.test(candidate.toLowerCase());
                }
            };
        }
    }

    static final class MatcherCombiner
    extends WildcardMatcher {
        private final WildcardMatcher[] wildcardMatchers;
        private final int hashCode;
        private final String asString;

        MatcherCombiner(Collection<WildcardMatcher> wildcardMatchers) {
            Preconditions.checkArgument((wildcardMatchers.size() > 1 ? 1 : 0) != 0);
            this.wildcardMatchers = wildcardMatchers.toArray(new WildcardMatcher[0]);
            this.hashCode = wildcardMatchers.hashCode();
            this.asString = wildcardMatchers.toString();
        }

        @Override
        public boolean test(String candidate) {
            for (int i = 0; i < this.wildcardMatchers.length; ++i) {
                if (!this.wildcardMatchers[i].test(candidate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public WildcardMatcher ignoreCase() {
            return new MatcherCombiner(Stream.of(this.wildcardMatchers).map(WildcardMatcher::ignoreCase).toList());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MatcherCombiner) {
                MatcherCombiner matcherCombiner = (MatcherCombiner)o;
                return Arrays.equals(this.wildcardMatchers, matcherCombiner.wildcardMatchers);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.asString;
        }
    }

    static abstract class AbstractSimpleWildcardMatcher
    extends WildcardMatcher {
        protected final String pattern;

        AbstractSimpleWildcardMatcher(String pattern) {
            this.pattern = pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AbstractSimpleWildcardMatcher) {
                AbstractSimpleWildcardMatcher simpleMatcher = (AbstractSimpleWildcardMatcher)o;
                return simpleMatcher.pattern.equals(this.pattern);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public String toString() {
            return this.pattern;
        }
    }
}

