/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.modifiers;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.securityanalytics.rules.exceptions.SigmaRegularExpressionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaValueError;
import org.opensearch.securityanalytics.rules.modifiers.SigmaModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaValueModifier;
import org.opensearch.securityanalytics.rules.objects.SigmaDetectionItem;
import org.opensearch.securityanalytics.rules.types.SigmaRegularExpression;
import org.opensearch.securityanalytics.rules.types.SigmaString;
import org.opensearch.securityanalytics.rules.types.SigmaType;
import org.opensearch.securityanalytics.rules.utils.Either;

public class SigmaRegularExpressionModifier
extends SigmaValueModifier {
    public SigmaRegularExpressionModifier(SigmaDetectionItem detectionItem, List<Class<? extends SigmaModifier>> appliedModifiers) {
        super(detectionItem, appliedModifiers);
    }

    @Override
    public Pair<Class<?>, Class<?>> getTypeHints() {
        return Pair.of(SigmaRegularExpression.class, SigmaString.class);
    }

    @Override
    public Either<SigmaType, List<SigmaType>> modify(Either<SigmaType, List<SigmaType>> val) throws SigmaValueError, SigmaRegularExpressionError {
        if (val.isLeft() && val.getLeft() instanceof SigmaString) {
            if (this.getAppliedModifiers().size() > 0) {
                throw new SigmaValueError("Regular expression modifier only applicable to unmodified values");
            }
            return Either.left(new SigmaRegularExpression(((SigmaString)val.getLeft()).getOriginal()));
        }
        return null;
    }
}

