/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.tasks;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.task.MLTaskDeleteRequest;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteTaskTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteTaskTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/tasks/delete", transportService, actionFilters, MLTaskDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLTaskDeleteRequest mlTaskDeleteRequest = MLTaskDeleteRequest.fromActionRequest((ActionRequest)request);
        String taskId = mlTaskDeleteRequest.getTaskId();
        String tenantId = mlTaskDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-task")).id(taskId)).fetchSourceContext(fetchSourceContext).tenantId(tenantId)).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((getDataObjectResponse, throwable) -> {
                if (throwable != null) {
                    this.handleGetError((Throwable)throwable, taskId, (ActionListener<DeleteResponse>)wrappedListener);
                    return;
                }
                this.processGetDataObjectResponse((GetDataObjectResponse)getDataObjectResponse, taskId, tenantId, (ActionListener<DeleteResponse>)wrappedListener);
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML task {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void handleGetError(Throwable throwable, String taskId, ActionListener<DeleteResponse> actionListener) {
        Exception rootCause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (ExceptionsHelper.unwrap((Throwable)rootCause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to find task index", (Throwable)rootCause);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find task", RestStatus.NOT_FOUND, (Throwable)rootCause, new Object[0]));
        } else {
            log.error("Failed to get ML task {}", (Object)taskId, (Object)rootCause);
            actionListener.onFailure(rootCause);
        }
    }

    private void processGetDataObjectResponse(GetDataObjectResponse getDataObjectResponse, String taskId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        try {
            GetResponse getResponse = getDataObjectResponse.getResponse();
            if (!getResponse.isExists()) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find task", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            this.processTask(getResponse, taskId, tenantId, actionListener);
        }
        catch (Exception e) {
            log.error("Failed to parse GetDataObjectResponse for task {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void processTask(GetResponse getResponse, String taskId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLTask mlTask = MLTask.parse((XContentParser)parser);
            if (!TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlTask.getTenantId(), actionListener)) {
                return;
            }
            if (mlTask.getState() == MLTaskState.RUNNING) {
                actionListener.onFailure(new Exception("Task cannot be deleted in running state. Try after some time."));
            } else {
                this.executeDelete(taskId, tenantId, actionListener);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse ML task {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void executeDelete(String taskId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-task", taskId);
        try {
            this.sdkClient.deleteDataObjectAsync(((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build()).whenComplete((deleteDataObjectResponse, throwable) -> {
                if (throwable != null) {
                    this.handleDeleteError((Throwable)throwable, taskId, actionListener);
                    return;
                }
                this.processDeleteResponse((DeleteDataObjectResponse)deleteDataObjectResponse, actionListener);
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML task: {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void handleDeleteError(Throwable throwable, String taskId, ActionListener<DeleteResponse> actionListener) {
        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        log.error("Failed to delete ML task: {}", (Object)taskId, (Object)cause);
        actionListener.onFailure(cause);
    }

    private void processDeleteResponse(DeleteDataObjectResponse deleteDataObjectResponse, ActionListener<DeleteResponse> actionListener) {
        try {
            DeleteResponse deleteResponse = deleteDataObjectResponse.deleteResponse();
            log.info("Task deletion result: {}, task id: {}", (Object)deleteResponse.getResult(), (Object)deleteResponse.getId());
            actionListener.onResponse((Object)deleteResponse);
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }
}

