/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.NonFallbackCalciteException;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class BackgroundSearchScanner {
    private final OpenSearchClient client;
    @Nullable
    private final Executor backgroundExecutor;
    private CompletableFuture<OpenSearchResponse> nextBatchFuture = null;
    private boolean stopIteration = false;

    public BackgroundSearchScanner(OpenSearchClient client) {
        this.client = client;
        this.backgroundExecutor = client.getNodeClient().isPresent() ? client.getNodeClient().get().threadPool().executor("sql_background_io") : null;
    }

    private boolean isAsync() {
        return this.backgroundExecutor != null;
    }

    public boolean isScanDone() {
        return this.stopIteration;
    }

    public void startScanning(OpenSearchRequest request) {
        if (this.isAsync()) {
            this.nextBatchFuture = CompletableFuture.supplyAsync(() -> this.client.search(request), this.backgroundExecutor);
        }
    }

    private OpenSearchResponse getCurrentResponse(OpenSearchRequest request) {
        if (this.isAsync()) {
            try {
                return this.nextBatchFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new NonFallbackCalciteException("Failed to fetch data from the index: the background task failed or interrupted.\n  Inner error: " + e.getMessage());
            }
        }
        return this.client.search(request);
    }

    public SearchBatchResult fetchNextBatch(OpenSearchRequest request, int maxResultWindow) {
        Iterator<ExprValue> iterator;
        OpenSearchResponse response = this.getCurrentResponse(request);
        if (response.isAggregationResponse() || response.isCountResponse() || response.getHitsSize() < maxResultWindow) {
            this.stopIteration = true;
        }
        if (!response.isEmpty()) {
            iterator = response.iterator();
            if (!this.stopIteration && this.isAsync()) {
                this.nextBatchFuture = CompletableFuture.supplyAsync(() -> this.client.search(request), this.backgroundExecutor);
            }
        } else {
            iterator = Collections.emptyIterator();
            this.stopIteration = true;
        }
        return new SearchBatchResult(iterator, this.stopIteration);
    }

    public void reset(OpenSearchRequest request) {
        this.stopIteration = false;
        this.startScanning(request);
    }

    public void close() {
        this.stopIteration = true;
        if (this.nextBatchFuture != null) {
            this.nextBatchFuture.cancel(true);
        }
    }

    public record SearchBatchResult(Iterator<ExprValue> iterator, boolean stopIteration) {
    }
}

