/*
 * Decompiled with CFR 0.152.
 */
package MultiKeyring_Compile;

import Keyring_Compile.VerifiableInterface;
import MultiKeyring_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;

public class MultiKeyring
implements VerifiableInterface,
IKeyring {
    public Option<IKeyring> _generatorKeyring = Option.Default(TypeDescriptor.reference(IKeyring.class));
    public DafnySequence<? extends IKeyring> _childKeyrings = DafnySequence.empty((TypeDescriptor)TypeDescriptor.reference(IKeyring.class));
    private static final TypeDescriptor<MultiKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(MultiKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out11 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out11;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out11 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out11;
    }

    public void __ctor(Option<IKeyring> generatorKeyring, DafnySequence<? extends IKeyring> childKeyrings) {
        this._generatorKeyring = generatorKeyring;
        this._childKeyrings = childKeyrings;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        if (this.generatorKeyring().is_None() && input.dtor_materials().dtor_plaintextDataKey().is_None()) {
            DafnySequence _0_exception = DafnySequence.asString((String)"Need either a generator keyring or input encryption materials which contain a plaintext data key");
            res = Result.create_Failure(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_0_exception));
            return res;
        }
        EncryptionMaterials _1_returnMaterials = input.dtor_materials();
        if (this.generatorKeyring().is_Some()) {
            Result<OnEncryptOutput, Error> _out0;
            Outcome<Error> _2_valueOrError0 = Outcome.Default(Error._typeDescriptor());
            _2_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_plaintextDataKey().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"This multi keyring has a generator but provided Encryption Materials already contain plaintext data key")));
            if (_2_valueOrError0.IsFailure(Error._typeDescriptor())) {
                res = _2_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Result<OnEncryptOutput, Error> _3_onEncryptOutput = _out0 = this.generatorKeyring().dtor_value().OnEncrypt(input);
            Outcome<Error> _4_valueOrError1 = Outcome.Default(Error._typeDescriptor());
            _4_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _3_onEncryptOutput.is_Success(), _3_onEncryptOutput.is_Failure() ? _3_onEncryptOutput.dtor_error() : Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected failure. Input to Need is !Success.")));
            if (_4_valueOrError1.IsFailure(Error._typeDescriptor())) {
                res = _4_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            if (!__default.Verified_q(this.generatorKeyring().dtor_value()) && !((Boolean)Helpers.Let((Object)this.generatorKeyring().dtor_value(), boxed27 -> {
                IKeyring _is_19 = boxed27;
                return _is_19 instanceof MultiKeyring;
            })).booleanValue()) {
                Outcome<Error> _5_valueOrError2 = Outcome.Default(Error._typeDescriptor());
                _5_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.EncryptionMaterialsHasPlaintextDataKey(_3_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Could not retrieve materials required for encryption")));
                if (_5_valueOrError2.IsFailure(Error._typeDescriptor())) {
                    res = _5_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                    return res;
                }
                Outcome<Error> _6_valueOrError3 = Outcome.Default(Error._typeDescriptor());
                _6_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _3_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Generator keyring returned invalid encryption materials")));
                if (_6_valueOrError3.IsFailure(Error._typeDescriptor())) {
                    res = _6_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                    return res;
                }
            }
            _1_returnMaterials = _3_onEncryptOutput.dtor_value().dtor_materials();
        }
        long _hi0 = this.childKeyrings().cardinalityInt();
        long _7_i = 0L;
        while (Long.compareUnsigned(_7_i, _hi0) < 0) {
            Result<OnEncryptOutput, Error> _out1;
            OnEncryptInput _8_onEncryptInput = OnEncryptInput.create(_1_returnMaterials);
            IKeyring _9_child = (IKeyring)this.childKeyrings().select(Helpers.unsignedToInt((long)_7_i));
            Result<OnEncryptOutput, Error> _10_onEncryptOutput = _out1 = _9_child.OnEncrypt(_8_onEncryptInput);
            Outcome<Error> _11_valueOrError4 = Outcome.Default(Error._typeDescriptor());
            _11_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _10_onEncryptOutput.is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring failed to encrypt plaintext data key")));
            if (_11_valueOrError4.IsFailure(Error._typeDescriptor())) {
                res = _11_valueOrError4.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            if (!__default.Verified_q(_9_child) && !((Boolean)Helpers.Let((Object)_9_child, boxed28 -> {
                IKeyring _is_20 = boxed28;
                return _is_20 instanceof MultiKeyring;
            })).booleanValue()) {
                Outcome<Error> _12_valueOrError5 = Outcome.Default(Error._typeDescriptor());
                _12_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.EncryptionMaterialsHasPlaintextDataKey(_10_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Could not retrieve materials required for encryption")));
                if (_12_valueOrError5.IsFailure(Error._typeDescriptor())) {
                    res = _12_valueOrError5.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                    return res;
                }
                Outcome<Error> _13_valueOrError6 = Outcome.Default(Error._typeDescriptor());
                _13_valueOrError6 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(_1_returnMaterials, _10_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring performed invalid transition on encryption materials")));
                if (_13_valueOrError6.IsFailure(Error._typeDescriptor())) {
                    res = _13_valueOrError6.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                    return res;
                }
            }
            _1_returnMaterials = _10_onEncryptOutput.dtor_value().dtor_materials();
            ++_7_i;
        }
        res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_1_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _0_materials = input.dtor_materials();
        Outcome<Error> _1_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _1_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(input.dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _2_failures = DafnySequence.empty(Error._typeDescriptor());
        if (this.generatorKeyring().is_Some()) {
            Result<OnDecryptOutput, Error> _out0 = __default.AttemptDecryptDataKey(this.generatorKeyring().dtor_value(), input);
            Result<OnDecryptOutput, Error> _3_result = _out0;
            if (_3_result.is_Success()) {
                if (_3_result.dtor_value().dtor_materials().dtor_plaintextDataKey().is_Some()) {
                    res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), _3_result.dtor_value());
                    return res;
                }
            } else {
                _2_failures = DafnySequence.concatenate((DafnySequence)_2_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_3_result.dtor_error()}));
            }
        }
        long _hi0 = this.childKeyrings().cardinalityInt();
        long _4_j = 0L;
        while (Long.compareUnsigned(_4_j, _hi0) < 0) {
            Result<OnDecryptOutput, Error> _out1 = __default.AttemptDecryptDataKey((IKeyring)this.childKeyrings().select(Helpers.unsignedToInt((long)_4_j)), input);
            Result<OnDecryptOutput, Error> _5_result = _out1;
            if (_5_result.is_Success()) {
                res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), _5_result.dtor_value());
                return res;
            }
            _2_failures = DafnySequence.concatenate((DafnySequence)_2_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_5_result.dtor_error()}));
            ++_4_j;
        }
        Error _6_combinedResult = Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_2_failures, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured Keyring was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), _6_combinedResult);
        return res;
    }

    public Option<IKeyring> generatorKeyring() {
        return this._generatorKeyring;
    }

    public DafnySequence<? extends IKeyring> childKeyrings() {
        return this._childKeyrings;
    }

    public static TypeDescriptor<MultiKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "MultiKeyring.MultiKeyring";
    }
}

