/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.TimescaleUnits;
import net.sf.mpxj.reader.UniversalProjectReader;
import net.sf.mpxj.utility.TimephasedUtility;
import net.sf.mpxj.utility.TimescaleUtility;

public class MpxjQuery {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: MpxQuery <input file name>");
            } else {
                MpxjQuery.query(stringArray[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static void query(String string) throws Exception {
        ProjectFile projectFile = new UniversalProjectReader().read(string);
        MpxjQuery.listProjectProperties(projectFile);
        MpxjQuery.listResources(projectFile);
        MpxjQuery.listTasks(projectFile);
        MpxjQuery.listAssignments(projectFile);
        MpxjQuery.listAssignmentsByTask(projectFile);
        MpxjQuery.listAssignmentsByResource(projectFile);
        MpxjQuery.listHierarchy(projectFile);
        MpxjQuery.listTaskNotes(projectFile);
        MpxjQuery.listResourceNotes(projectFile);
        MpxjQuery.listRelationships(projectFile);
        MpxjQuery.listSlack(projectFile);
        MpxjQuery.listCalendars(projectFile);
    }

    private static void listProjectProperties(ProjectFile projectFile) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        ProjectProperties projectProperties = projectFile.getProjectProperties();
        Date date = projectProperties.getStartDate();
        Date date2 = projectProperties.getFinishDate();
        String string = date == null ? "(none)" : simpleDateFormat.format(date);
        String string2 = date2 == null ? "(none)" : simpleDateFormat.format(date2);
        System.out.println("MPP file type: " + projectProperties.getMppFileType());
        System.out.println("Project Properties: StartDate=" + string + " FinishDate=" + string2);
        System.out.println();
    }

    private static void listResources(ProjectFile projectFile) {
        for (Resource resource : projectFile.getResources()) {
            System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ") Start=" + String.valueOf(resource.getStart()) + " Finish=" + String.valueOf(resource.getFinish()));
        }
        System.out.println();
    }

    private static void listTasks(ProjectFile projectFile) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm z");
        for (Task task : projectFile.getTasks()) {
            Date date = task.getStart();
            String string = task.getStartText();
            String string2 = string != null ? string : (date != null ? simpleDateFormat.format(date) : "(no start date supplied)");
            date = task.getFinish();
            string = task.getFinishText();
            String string3 = string != null ? string : (date != null ? simpleDateFormat.format(date) : "(no finish date supplied)");
            Duration duration = task.getDuration();
            string = task.getDurationText();
            String string4 = string != null ? string : (duration != null ? duration.toString() : "(no duration supplied)");
            duration = task.getActualDuration();
            String string5 = duration != null ? duration.toString() : "(no actual duration supplied)";
            String string6 = task.getBaselineDurationText();
            if (string6 == null) {
                duration = task.getBaselineDuration();
                string6 = duration != null ? duration.toString() : "(no duration supplied)";
            }
            System.out.println("Task: " + task.getName() + " ID=" + task.getID() + " Unique ID=" + task.getUniqueID() + " (Start Date=" + string2 + " Finish Date=" + string3 + " Duration=" + string4 + " Actual Duration" + string5 + " Baseline Duration=" + string6 + " Outline Level=" + task.getOutlineLevel() + " Outline Number=" + task.getOutlineNumber() + " Recurring=" + task.getRecurring() + ")");
        }
        System.out.println();
    }

    private static void listHierarchy(ProjectFile projectFile) {
        for (Task task : projectFile.getChildTasks()) {
            System.out.println("Task: " + task.getName() + "\t" + String.valueOf(task.getStart()) + "\t" + String.valueOf(task.getFinish()));
            MpxjQuery.listHierarchy(task, " ");
        }
        System.out.println();
    }

    private static void listHierarchy(Task task, String string) {
        for (Task task2 : task.getChildTasks()) {
            System.out.println(string + "Task: " + task2.getName() + "\t" + String.valueOf(task2.getStart()) + "\t" + String.valueOf(task2.getFinish()));
            MpxjQuery.listHierarchy(task2, string + " ");
        }
    }

    private static void listAssignments(ProjectFile projectFile) {
        for (ResourceAssignment resourceAssignment : projectFile.getResourceAssignments()) {
            Task task = resourceAssignment.getTask();
            String string = task == null ? "(null task)" : task.getName();
            Resource resource = resourceAssignment.getResource();
            String string2 = resource == null ? "(null resource)" : resource.getName();
            System.out.println("Assignment: Task=" + string + " Resource=" + string2);
            if (task == null) continue;
            MpxjQuery.listTimephasedWork(resourceAssignment);
        }
        System.out.println();
    }

    private static void listTimephasedWork(ResourceAssignment resourceAssignment) {
        Task task = resourceAssignment.getTask();
        int n = (int)((task.getFinish().getTime() - task.getStart().getTime()) / 86400000L) + 1;
        if (n > 1) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
            TimescaleUtility timescaleUtility = new TimescaleUtility();
            ArrayList<DateRange> arrayList = timescaleUtility.createTimescale(task.getStart(), TimescaleUnits.DAYS, n);
            TimephasedUtility timephasedUtility = new TimephasedUtility();
            ArrayList<Duration> arrayList2 = timephasedUtility.segmentWork(resourceAssignment.getCalendar(), resourceAssignment.getTimephasedWork(), TimescaleUnits.DAYS, arrayList);
            for (DateRange comparable : arrayList) {
                System.out.print(simpleDateFormat.format(comparable.getStart()) + "\t");
            }
            System.out.println();
            for (Duration duration : arrayList2) {
                System.out.print(duration.toString() + "        ".substring(0, 7) + "\t");
            }
            System.out.println();
        }
    }

    private static void listAssignmentsByTask(ProjectFile projectFile) {
        for (Task task : projectFile.getTasks()) {
            System.out.println("Assignments for task " + task.getName() + ":");
            for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
                Resource resource = resourceAssignment.getResource();
                String string = resource == null ? "(null resource)" : resource.getName();
                System.out.println("   " + string);
            }
        }
        System.out.println();
    }

    private static void listAssignmentsByResource(ProjectFile projectFile) {
        for (Resource resource : projectFile.getResources()) {
            System.out.println("Assignments for resource " + resource.getName() + ":");
            for (ResourceAssignment resourceAssignment : resource.getTaskAssignments()) {
                Task task = resourceAssignment.getTask();
                System.out.println("   " + task.getName());
            }
        }
        System.out.println();
    }

    private static void listTaskNotes(ProjectFile projectFile) {
        for (Task task : projectFile.getTasks()) {
            String string = task.getNotes();
            if (string.length() == 0) continue;
            System.out.println("Notes for " + task.getName() + ": " + string);
        }
        System.out.println();
    }

    private static void listResourceNotes(ProjectFile projectFile) {
        for (Resource resource : projectFile.getResources()) {
            String string = resource.getNotes();
            if (string.length() == 0) continue;
            System.out.println("Notes for " + resource.getName() + ": " + string);
        }
        System.out.println();
    }

    private static void listRelationships(ProjectFile projectFile) {
        for (Task task : projectFile.getTasks()) {
            System.out.print(task.getID());
            System.out.print('\t');
            System.out.print(task.getName());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getPredecessors());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getSuccessors());
            System.out.println();
        }
    }

    private static void dumpRelationList(List<Relation> list) {
        if (list != null && !list.isEmpty()) {
            if (list.size() > 1) {
                System.out.print('\"');
            }
            boolean bl = true;
            for (Relation relation : list) {
                if (!bl) {
                    System.out.print(',');
                }
                bl = false;
                System.out.print(relation.getTargetTask().getID());
                Duration duration = relation.getLag();
                if (relation.getType() != RelationType.FINISH_START || duration.getDuration() != 0.0) {
                    System.out.print(relation.getType());
                }
                if (duration.getDuration() == 0.0) continue;
                if (duration.getDuration() > 0.0) {
                    System.out.print("+");
                }
                System.out.print(duration);
            }
            if (list.size() > 1) {
                System.out.print('\"');
            }
        }
    }

    private static void listSlack(ProjectFile projectFile) {
        for (Task task : projectFile.getTasks()) {
            System.out.println(task.getName() + " Total Slack=" + String.valueOf(task.getTotalSlack()) + " Start Slack=" + String.valueOf(task.getStartSlack()) + " Finish Slack=" + String.valueOf(task.getFinishSlack()));
        }
    }

    private static void listCalendars(ProjectFile projectFile) {
        for (ProjectCalendar projectCalendar : projectFile.getCalendars()) {
            System.out.println(projectCalendar.toString());
        }
    }
}

