/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.FilteringSpeedSearch;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UiScopeKt;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.ui.branch.dashboard.BestMatch;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesTreeMatcher;
import git4idea.ui.branch.dashboard.FilteringBranchesTreeBase;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.AdaptedFunctionReference;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0010H\u0014J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010\u001f\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010 \u001a\u00020\u0013H\u0002J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesFilteringSpeedSearch;", "Lcom/intellij/ui/FilteringSpeedSearch;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTreeBase;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "<init>", "(Lgit4idea/ui/branch/dashboard/FilteringBranchesTreeBase;Lcom/intellij/ui/SearchTextField;)V", "filterPattern", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "bestMatch", "Lgit4idea/ui/branch/dashboard/BestMatch;", "checkMatching", "Lcom/intellij/ui/FilteringTree$Matching;", "node", "onMatchingChecked", "", "userObject", "matchingFragments", "", "Lcom/intellij/openapi/util/TextRange;", "result", "createNewMatcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "searchText", "getMatcher", "onSearchPatternUpdated", "pattern", "refilter", "updateSpeedSearchBackground", "updateSelection", "scrollToSelected", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/BranchesFilteringSpeedSearch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,512:1\n1#2:513\n*E\n"})
final class BranchesFilteringSpeedSearch
extends FilteringSpeedSearch<BranchTreeNode, BranchNodeDescriptor> {
    @NotNull
    private final FilteringBranchesTreeBase tree;
    @NotNull
    private final SearchTextField searchTextField;
    @NotNull
    private final MutableStateFlow<String> filterPattern;
    @Nullable
    private BestMatch bestMatch;

    public BranchesFilteringSpeedSearch(@NotNull FilteringBranchesTreeBase tree, @NotNull SearchTextField searchTextField) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"searchTextField");
        super((FilteringTree)tree, searchTextField);
        this.tree = tree;
        this.searchTextField = searchTextField;
        this.filterPattern = StateFlowKt.MutableStateFlow(null);
        UiScopeKt.launchOnShow$default((Component)((Component)this.tree.getTree()), (String)"Branches Tree Filterer", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BranchesFilteringSpeedSearch this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ BranchesFilteringSpeedSearch this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        final BranchesFilteringSpeedSearch branchesFilteringSpeedSearch = this.this$0;
                                        this.label = 1;
                                        Object object2 = FlowKt.debounce((Flow)FlowKt.filterNotNull((Flow)((Flow)this.this$0.filterPattern)), (long)100L).collect(new FlowCollector(){

                                            public final Object emit(String p0, Continuation<? super Unit> $completion) {
                                                Object object = 1.invokeSuspend$refilter(branchesFilteringSpeedSearch, p0, $completion);
                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                    return object;
                                                }
                                                return Unit.INSTANCE;
                                            }

                                            public final Function<?> getFunctionDelegate() {
                                                return (Function)new AdaptedFunctionReference(2, (Object)branchesFilteringSpeedSearch, BranchesFilteringSpeedSearch.class, "refilter", "refilter(Ljava/lang/String;)V", 4);
                                            }

                                            public final boolean equals(Object other) {
                                                return other instanceof FlowCollector ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                                            }

                                            public final int hashCode() {
                                                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                                            }
                                        }, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final /* synthetic */ Object invokeSuspend$refilter(BranchesFilteringSpeedSearch $this$invokeSuspend_u24refilter, String p0, Continuation $completion) {
                                $this$invokeSuspend_u24refilter.refilter(p0);
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public FilteringTree.Matching checkMatching(@NotNull BranchTreeNode node) {
        FilteringTree.Matching matching;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getNodeDescriptor() instanceof BranchNodeDescriptor.Group) {
            matching = FilteringTree.Matching.NONE;
        } else {
            FilteringTree.Matching matching2 = super.checkMatching((DefaultMutableTreeNode)node);
            matching = matching2;
            Intrinsics.checkNotNullExpressionValue((Object)matching2, (String)"checkMatching(...)");
        }
        return matching;
    }

    protected void onMatchingChecked(@NotNull BranchNodeDescriptor userObject, @Nullable Iterable<? extends TextRange> matchingFragments, @NotNull FilteringTree.Matching result2) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        MinusculeMatcher minusculeMatcher = this.getMatcher();
        if (minusculeMatcher == null) {
            return;
        }
        MinusculeMatcher matcher = minusculeMatcher;
        if (result2 == FilteringTree.Matching.NONE) {
            return;
        }
        String string = this.tree.getText(userObject);
        if (string == null) {
            return;
        }
        String text2 = string;
        TextRange textRange = matchingFragments;
        if (textRange == null || (textRange = (TextRange)CollectionsKt.singleOrNull(textRange)) == null) {
            return;
        }
        TextRange singleMatch = textRange;
        int matchingDegree = matcher.matchingDegree(text2, false, FList.singleton((Object)singleMatch));
        BestMatch bestMatch = this.bestMatch;
        if (matchingDegree > (bestMatch != null ? bestMatch.getMatchingDegree() : 0)) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.tree.getSearchModel().getNode((Object)userObject);
            Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"getNode(...)");
            BranchTreeNode node = (BranchTreeNode)defaultMutableTreeNode;
            this.bestMatch = new BestMatch(matchingDegree, node);
        }
    }

    @NotNull
    protected MinusculeMatcher createNewMatcher(@Nullable String searchText) {
        return new BranchesTreeMatcher(searchText);
    }

    @Nullable
    public MinusculeMatcher getMatcher() {
        return (MinusculeMatcher)super.getMatcher();
    }

    protected void onSearchPatternUpdated(@Nullable String pattern) {
        String string = pattern;
        if (string == null) {
            string = "";
        }
        this.filterPattern.tryEmit((Object)string);
    }

    public void refilter(@Nullable String pattern) {
        this.bestMatch = null;
        super.refilter(pattern);
        this.updateSpeedSearchBackground();
    }

    private final void updateSpeedSearchBackground() {
        JBTextField jBTextField = this.searchTextField.getTextEditor();
        if (jBTextField == null) {
            return;
        }
        JBTextField textEditor = jBTextField;
        if (this.tree.isEmptyModel()) {
            textEditor.setOpaque(true);
            this.noHits();
        } else {
            textEditor.setOpaque(false);
            textEditor.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    public void updateSelection() {
        MinusculeMatcher matcher = this.getMatcher();
        BestMatch bestMatch = this.bestMatch;
        if (matcher == null || bestMatch == null) {
            super.updateSelection();
        } else {
            int selectionMatchingDegree;
            String selectionText;
            BranchTreeNode branchTreeNode = (BranchTreeNode)this.getSelection();
            String string = selectionText = this.tree.getText(branchTreeNode != null ? branchTreeNode.getNodeDescriptor() : null);
            int n = selectionMatchingDegree = string != null ? matcher.matchingDegree(string) : Integer.MIN_VALUE;
            if (selectionMatchingDegree < bestMatch.getMatchingDegree()) {
                this.select(bestMatch.getNode());
            }
        }
        CharSequence charSequence = this.getEnteredPrefix();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.scrollToSelected();
        }
    }

    private final void scrollToSelected() {
        block0: {
            Tree tree = this.tree.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
            Tree innerTree = tree;
            TreePath treePath = innerTree.getSelectionPath();
            if (treePath == null) break block0;
            TreePath it = treePath;
            boolean bl = false;
            TreeUtil.scrollToVisible((JTree)((JTree)innerTree), (TreePath)it, (boolean)false);
        }
    }
}

