/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BitSet;
import scala.collection.BitSetOps;
import scala.collection.BitSetOps$;
import scala.collection.Factory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SortedIterableFactory;
import scala.collection.SortedOps;
import scala.collection.SortedSetFactoryDefaults;
import scala.collection.SortedSetOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSetOps;
import scala.collection.StrictOptimizedSortedSetOps;
import scala.collection.immutable.Range;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.BitSet$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.SetOps;
import scala.collection.mutable.Shrinkable;
import scala.collection.mutable.SortedSet;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BitSet
extends AbstractSet<Object>
implements SortedSet<Object>,
StrictOptimizedSortedSetOps<Object, SortedSet, BitSet>,
scala.collection.BitSet,
Serializable {
    private long[] elems;

    public static Object fill(int n, Function0 function0) {
        return BitSet$.MODULE$.fill(n, function0);
    }

    public static BitSet fromBitMask(long[] lArray) {
        return BitSet$.MODULE$.fromBitMask(lArray);
    }

    public static Builder<Object, BitSet> newBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    public static Factory<Object, BitSet> specificIterableFactory() {
        return BitSet$.MODULE$.specificIterableFactory();
    }

    public BitSet(long[] elems) {
        this.elems = elems;
        SortedOps.$init$(this);
        SortedSetOps.$init$(this);
        SortedSetFactoryDefaults.$init$(this);
        scala.collection.SortedSet.$init$(this);
        SortedSet.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSetOps.$init$(this);
        StrictOptimizedSortedSetOps.$init$(this);
        BitSetOps.$init$(this);
        scala.collection.BitSet.$init$(this);
    }

    @Override
    public int compare(Object k0, Object k1) {
        return SortedOps.compare$(this, k0, k1);
    }

    @Override
    public Object range(Object from, Object until) {
        return SortedOps.range$(this, from, until);
    }

    @Override
    public final Object from(Object from) {
        return SortedOps.from$(this, from);
    }

    @Override
    public Object rangeFrom(Object from) {
        return SortedOps.rangeFrom$(this, from);
    }

    @Override
    public final Object until(Object until) {
        return SortedOps.until$(this, until);
    }

    @Override
    public Object rangeUntil(Object until) {
        return SortedOps.rangeUntil$(this, until);
    }

    @Override
    public final Object to(Object to) {
        return SortedOps.to$(this, to);
    }

    @Override
    public Iterator keysIteratorFrom(Object start) {
        return SortedSetOps.keysIteratorFrom$(this, start);
    }

    @Override
    public Object firstKey() {
        return SortedSetOps.firstKey$(this);
    }

    @Override
    public Object lastKey() {
        return SortedSetOps.lastKey$(this);
    }

    @Override
    public Option minAfter(Object key) {
        return SortedSetOps.minAfter$(this, key);
    }

    @Override
    public Option maxBefore(Object key) {
        return SortedSetOps.maxBefore$(this, key);
    }

    @Override
    public SortedSetOps rangeTo(Object to) {
        return SortedSetOps.rangeTo$(this, to);
    }

    @Override
    public SortedSetOps.WithFilter<Object, scala.collection.mutable.Set, SortedSet> withFilter(Function1<Object, Object> p) {
        return SortedSetFactoryDefaults.withFilter$(this, p);
    }

    @Override
    public boolean equals(Object that) {
        return scala.collection.SortedSet.equals$(this, that);
    }

    @Override
    public SortedIterableFactory<SortedSet> sortedIterableFactory() {
        return SortedSet.sortedIterableFactory$(this);
    }

    @Override
    public Tuple2<BitSet, BitSet> span(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.mutable.Set<A1>, scala.collection.mutable.Set<A2>> unzip(Function1<Object, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.mutable.Set<A1>, scala.collection.mutable.Set<A2>, scala.collection.mutable.Set<A3>> unzip3(Function1<Object, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<Object, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<Object, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<Object, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<Object, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<Object, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.mutable.Set<A1>, scala.collection.mutable.Set<A2>> partitionMap(Function1<Object, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public final Ordering<Object> ordering() {
        return BitSetOps.ordering$(this);
    }

    @Override
    public boolean contains(int elem) {
        return BitSetOps.contains$(this, elem);
    }

    @Override
    public Iterator<Object> iterator() {
        return BitSetOps.iterator$(this);
    }

    @Override
    public Iterator<Object> iteratorFrom(int start) {
        return BitSetOps.iteratorFrom$(this, start);
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<Object, S> shape) {
        return (S)BitSetOps.stepper$(this, shape);
    }

    @Override
    public int size() {
        return BitSetOps.size$(this);
    }

    @Override
    public boolean isEmpty() {
        return BitSetOps.isEmpty$(this);
    }

    @Override
    public <B> int max(Ordering<B> ord) {
        return BitSetOps.max$(this, ord);
    }

    @Override
    public <B> int min(Ordering<B> ord) {
        return BitSetOps.min$(this, ord);
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        BitSetOps.foreach$(this, f);
    }

    @Override
    public scala.collection.BitSet rangeImpl(Option from, Option until) {
        return BitSetOps.rangeImpl$(this, from, until);
    }

    @Override
    public scala.collection.BitSet concat(IterableOnce other) {
        return BitSetOps.concat$(this, other);
    }

    @Override
    public scala.collection.BitSet intersect(Set other) {
        return BitSetOps.intersect$(this, other);
    }

    @Override
    public scala.collection.BitSet xor(scala.collection.BitSet other) {
        return BitSetOps.xor$(this, other);
    }

    @Override
    public final scala.collection.BitSet $up(scala.collection.BitSet other) {
        return BitSetOps.$up$(this, other);
    }

    @Override
    public Tuple2<BitSet, BitSet> partition(Function1<Object, Object> p) {
        return BitSetOps.partition$(this, p);
    }

    @Override
    public String stringPrefix() {
        return scala.collection.BitSet.stringPrefix$(this);
    }

    public /* synthetic */ int scala$collection$SortedSetOps$$super$min(Ordering ord) {
        return BoxesRunTime.unboxToInt(IterableOnceOps.min$(this, ord));
    }

    public /* synthetic */ int scala$collection$SortedSetOps$$super$max(Ordering ord) {
        return BoxesRunTime.unboxToInt(IterableOnceOps.max$(this, ord));
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return Set.equals$(this, that);
    }

    @Override
    public /* synthetic */ int scala$collection$BitSetOps$$super$max(Ordering ord) {
        return BoxesRunTime.unboxToInt(SortedSetOps.max$(this, ord));
    }

    @Override
    public /* synthetic */ int scala$collection$BitSetOps$$super$min(Ordering ord) {
        return BoxesRunTime.unboxToInt(SortedSetOps.min$(this, ord));
    }

    @Override
    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$concat(IterableOnce that) {
        return (BitSet)StrictOptimizedSetOps.concat$(this, that);
    }

    @Override
    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$intersect(Set that) {
        return (BitSet)scala.collection.SetOps.intersect$(this, that);
    }

    @Override
    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$diff(Set that) {
        return (BitSet)SetOps.diff$(this, that);
    }

    public final long[] elems() {
        return this.elems;
    }

    public final void elems_$eq(long[] x$1) {
        this.elems = x$1;
    }

    public BitSet(int initSize) {
        this(new long[scala.math.package$.MODULE$.max(initSize + 63 >> 6, 1)]);
    }

    public BitSet() {
        this(0);
    }

    @Override
    public BitSet fromSpecific(IterableOnce<Object> coll) {
        return this.bitSetFactory().fromSpecific((IterableOnce)coll);
    }

    @Override
    public Builder<Object, BitSet> newSpecificBuilder() {
        return this.bitSetFactory().newBuilder();
    }

    @Override
    public BitSet empty() {
        return this.bitSetFactory().empty();
    }

    public BitSet$ bitSetFactory() {
        return BitSet$.MODULE$;
    }

    @Override
    public scala.collection.mutable.Set<Object> unsorted() {
        return this;
    }

    @Override
    public final int nwords() {
        return this.elems().length;
    }

    @Override
    public final long word(int idx) {
        if (idx < this.nwords()) {
            return this.elems()[idx];
        }
        return 0L;
    }

    @Override
    public BitSet fromBitMaskNoCopy(long[] elems) {
        if (elems.length == 0) {
            return this.empty();
        }
        return new BitSet(elems);
    }

    public BitSet addOne(int elem) {
        Predef$.MODULE$.require(elem >= 0);
        if (!this.contains(elem)) {
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) | 1L << elem);
        }
        return this;
    }

    public BitSet subtractOne(int elem) {
        Predef$.MODULE$.require(elem >= 0);
        if (this.contains(elem)) {
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) & (1L << elem ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return this;
    }

    @Override
    public void clear() {
        this.elems_$eq(new long[this.elems().length]);
    }

    public final void updateWord(int idx, long w) {
        this.ensureCapacity(idx);
        this.elems()[idx] = w;
    }

    public final void ensureCapacity(int idx) {
        Predef$.MODULE$.require(idx < 0x2000000);
        if (idx >= this.nwords()) {
            int newlen = this.nwords();
            while (idx >= newlen) {
                newlen = scala.math.package$.MODULE$.min(newlen * 2, 0x2000000);
            }
            long[] elems1 = new long[newlen];
            Array$.MODULE$.copy(this.elems(), 0, elems1, 0, this.nwords());
            this.elems_$eq(elems1);
            return;
        }
    }

    public Set<Object> unconstrained() {
        return this;
    }

    public BitSet $bar$eq(scala.collection.BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        int othernwords = other.nwords();
        for (int i = 0; i < othernwords; ++i) {
            this.elems()[i] = this.elems()[i] | other.word(i);
        }
        return this;
    }

    public BitSet $amp$eq(scala.collection.BitSet other) {
        int thisnwords = this.nwords();
        for (int i = 0; i < thisnwords; ++i) {
            this.elems()[i] = this.elems()[i] & other.word(i);
        }
        return this;
    }

    public BitSet $up$eq(scala.collection.BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        int othernwords = other.nwords();
        for (int i = 0; i < othernwords; ++i) {
            this.elems()[i] = this.elems()[i] ^ other.word(i);
        }
        return this;
    }

    public BitSet $amp$tilde$eq(scala.collection.BitSet other) {
        int max = Math.min(this.nwords(), other.nwords());
        for (int i = 0; i < max; ++i) {
            this.elems()[i] = this.elems()[i] & (other.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this;
    }

    @Override
    public BitSet clone() {
        return new BitSet(Arrays.copyOf(this.elems(), this.elems().length));
    }

    public scala.collection.immutable.BitSet toImmutable() {
        return scala.collection.immutable.BitSet$.MODULE$.fromBitMask(this.elems());
    }

    @Override
    public BitSet map(Function1<Object, Object> f) {
        return this.strictOptimizedMap((Builder<B, C2>)this.newSpecificBuilder(), (Function1)f);
    }

    @Override
    public <B> SortedSet<B> map(Function1<Object, B> f, Ordering<B> ev) {
        return (SortedSet)StrictOptimizedSortedSetOps.map$(this, f, ev);
    }

    @Override
    public BitSet flatMap(Function1<Object, IterableOnce<Object>> f) {
        return this.strictOptimizedFlatMap((Builder<B, C2>)this.newSpecificBuilder(), f);
    }

    @Override
    public <B> SortedSet<B> flatMap(Function1<Object, IterableOnce<B>> f, Ordering<B> ev) {
        return (SortedSet)StrictOptimizedSortedSetOps.flatMap$(this, f, ev);
    }

    @Override
    public BitSet collect(PartialFunction<Object, Object> pf) {
        return this.strictOptimizedCollect((Builder<B, C2>)this.newSpecificBuilder(), (PartialFunction)pf);
    }

    @Override
    public <B> SortedSet<B> collect(PartialFunction<Object, B> pf, Ordering<B> ev) {
        return (SortedSet)StrictOptimizedSortedSetOps.collect$(this, pf, ev);
    }

    @Override
    public <B> SortedSet<Tuple2<Object, B>> zip(IterableOnce<B> that, Ordering<Tuple2<Object, B>> ev) {
        return (SortedSet)StrictOptimizedSortedSetOps.zip$(this, that, ev);
    }

    public BitSet addAll(IterableOnce<Object> xs) {
        IterableOnce<Object> iterableOnce = xs;
        if (iterableOnce instanceof scala.collection.BitSet) {
            scala.collection.BitSet bitSet;
            scala.collection.BitSet bs = bitSet = (scala.collection.BitSet)iterableOnce;
            return this.$bar$eq(bs);
        }
        if (iterableOnce instanceof Range) {
            Range range = (Range)iterableOnce;
            Range range2 = range;
            if (range2.nonEmpty()) {
                int start = range2.min(Ordering$Int$.MODULE$);
                if (start >= 0) {
                    int end = range2.max(Ordering$Int$.MODULE$);
                    int endIdx = end >> 6;
                    this.ensureCapacity(endIdx);
                    if (range2.step() == 1 || range2.step() == -1) {
                        int startIdx = start >> 6;
                        int wordStart = startIdx * 64;
                        long wordMask = -1L << start - wordStart;
                        if (endIdx > startIdx) {
                            long[] lArray = this.elems();
                            lArray[startIdx] = lArray[startIdx] | wordMask;
                            Arrays.fill(this.elems(), startIdx + 1, endIdx, -1L);
                            long[] lArray2 = this.elems();
                            lArray2[endIdx] = lArray2[endIdx] | -1L >>> 64 - (end - endIdx * 64) - 1;
                        } else {
                            long[] lArray = this.elems();
                            lArray[endIdx] = lArray[endIdx] | wordMask & -1L >>> 64 - (end - wordStart) - 1;
                        }
                    } else {
                        Growable.addAll$(this, range2);
                    }
                } else {
                    Growable.addAll$(this, range2);
                }
            }
            return this;
        }
        if (iterableOnce instanceof scala.collection.SortedSet) {
            scala.collection.SortedSet sortedSet = (scala.collection.SortedSet)iterableOnce;
            scala.collection.SortedSet sorted = sortedSet;
            if (sorted.nonEmpty()) {
                Ordering ord = sorted.ordering();
                package$.MODULE$.Ordering();
                if (ord == Ordering$Int$.MODULE$) {
                    this.ensureCapacity(BoxesRunTime.unboxToInt(sorted.lastKey()) >> 6);
                } else {
                    package$.MODULE$.Ordering();
                    if (ord == Ordering$Int$.MODULE$.reverse()) {
                        this.ensureCapacity(BoxesRunTime.unboxToInt(sorted.firstKey()) >> 6);
                    }
                }
                Iterator iter = sorted.iterator();
                while (iter.hasNext()) {
                    this.addOne(BoxesRunTime.unboxToInt(iter.next()));
                }
            }
            return this;
        }
        IterableOnce<Object> other = iterableOnce;
        return (BitSet)Growable.addAll$(this, other);
    }

    @Override
    public boolean subsetOf(Set<Object> that) {
        Set<Object> set = that;
        if (set instanceof scala.collection.BitSet) {
            scala.collection.BitSet bitSet;
            scala.collection.BitSet bs = bitSet = (scala.collection.BitSet)set;
            int thisnwords = this.nwords();
            int bsnwords = bs.nwords();
            int minWords = Math.min(thisnwords, bsnwords);
            for (int i = bsnwords; i < thisnwords; ++i) {
                if (this.word(i) == 0L) continue;
                return false;
            }
            for (int j = 0; j < minWords; ++j) {
                if ((this.word(j) & (bs.word(j) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
            return true;
        }
        Set<Object> other = set;
        return scala.collection.SetOps.subsetOf$(this, other);
    }

    public BitSet subtractAll(IterableOnce<Object> xs) {
        IterableOnce<Object> iterableOnce = xs;
        if (iterableOnce instanceof scala.collection.BitSet) {
            scala.collection.BitSet bitSet;
            scala.collection.BitSet bs = bitSet = (scala.collection.BitSet)iterableOnce;
            return this.$amp$tilde$eq(bs);
        }
        IterableOnce<Object> other = iterableOnce;
        return (BitSet)Shrinkable.subtractAll$(this, other);
    }

    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    @Override
    public BitSet diff(Set<Object> that) {
        Set<Object> set = that;
        if (set instanceof scala.collection.BitSet) {
            int thisnwords;
            scala.collection.BitSet bitSet = (scala.collection.BitSet)set;
            scala.collection.BitSet bs = bitSet;
            int bsnwords = bs.nwords();
            if (bsnwords >= (thisnwords = this.nwords())) {
                int i;
                long currentWord = 0L;
                for (i = thisnwords - 1; i >= 0 && currentWord == 0L; --i) {
                    long oldWord = this.word(i);
                    currentWord = oldWord & (bs.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                if (i < 0) {
                    return this.fromBitMaskNoCopy(new long[]{currentWord});
                }
                int minimumNonZeroIndex = i + 1;
                Object object = Predef$.MODULE$.longArrayOps(this.elems());
                long[] newArray = (long[])ArrayOps$.MODULE$.take$extension(object, minimumNonZeroIndex + 1);
                newArray[i + 1] = currentWord;
                while (i >= 0) {
                    newArray[i] = this.word(i) & (bs.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
                    --i;
                }
                return this.fromBitMaskNoCopy(newArray);
            }
            long[] newElems = (long[])this.elems().clone();
            for (int i = bsnwords - 1; i >= 0; --i) {
                newElems[i] = this.word(i) & (bs.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return this.fromBitMaskNoCopy(newElems);
        }
        return (BitSet)BitSetOps.diff$(this, that);
    }

    @Override
    public BitSet filterImpl(Function1<Object, Object> pred, boolean isFlipped) {
        long[] newArray = null;
        for (int i = this.nwords() - 1; i >= 0; --i) {
            long w = BitSetOps$.MODULE$.computeWordForFilter(pred, isFlipped, this.word(i), i);
            if (w == 0L) continue;
            if (newArray == null) {
                newArray = new long[i + 1];
            }
            newArray[i] = w;
        }
        if (newArray == null) {
            return this.empty();
        }
        return this.fromBitMaskNoCopy(newArray);
    }

    public BitSet filterInPlace(Function1<Object, Object> p) {
        int thisnwords = this.nwords();
        for (int i = 0; i < thisnwords; ++i) {
            this.elems()[i] = BitSetOps$.MODULE$.computeWordForFilter(p, false, this.elems()[i], i);
        }
        return this;
    }

    @Override
    public long[] toBitMask() {
        return (long[])this.elems().clone();
    }

    public static final class SerializationProxy
    extends BitSet.SerializationProxy {
        private static final long serialVersionUID = 3L;

        public SerializationProxy(BitSet coll) {
            super(coll);
        }

        private BitSet coll$accessor() {
            return (BitSet)super.coll();
        }

        @Override
        public Object readResolve() {
            return BitSet$.MODULE$.fromBitMaskNoCopy(this.elems());
        }
    }
}

