/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.MemoryRecords;

public class ShareFetchResponseDataJsonConverter {
    public static ShareFetchResponseData read(JsonNode _node, short _version) {
        ShareFetchResponseData.NodeEndpointCollection _collection;
        ShareFetchResponseData.ShareFetchableTopicResponseCollection _collection2;
        ShareFetchResponseData _object = new ShareFetchResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ShareFetchResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ShareFetchResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("ShareFetchResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ShareFetchResponseData");
        JsonNode _errorMessageNode = _node.get("errorMessage");
        if (_errorMessageNode == null) {
            throw new RuntimeException("ShareFetchResponseData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
        }
        if (_errorMessageNode.isNull()) {
            _object.errorMessage = null;
        } else {
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("ShareFetchResponseData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.errorMessage = _errorMessageNode.asText();
        }
        JsonNode _acquisitionLockTimeoutMsNode = _node.get("acquisitionLockTimeoutMs");
        if (_acquisitionLockTimeoutMsNode == null) {
            throw new RuntimeException("ShareFetchResponseData: unable to locate field 'acquisitionLockTimeoutMs', which is mandatory in version " + _version);
        }
        _object.acquisitionLockTimeoutMs = MessageUtil.jsonNodeToInt(_acquisitionLockTimeoutMsNode, "ShareFetchResponseData");
        JsonNode _responsesNode = _node.get("responses");
        if (_responsesNode == null) {
            throw new RuntimeException("ShareFetchResponseData: unable to locate field 'responses', which is mandatory in version " + _version);
        }
        if (!_responsesNode.isArray()) {
            throw new RuntimeException("ShareFetchResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.responses = _collection2 = new ShareFetchResponseData.ShareFetchableTopicResponseCollection(_responsesNode.size());
        for (JsonNode _element : _responsesNode) {
            _collection2.add(ShareFetchableTopicResponseJsonConverter.read(_element, _version));
        }
        JsonNode _nodeEndpointsNode = _node.get("nodeEndpoints");
        if (_nodeEndpointsNode == null) {
            throw new RuntimeException("ShareFetchResponseData: unable to locate field 'nodeEndpoints', which is mandatory in version " + _version);
        }
        if (!_nodeEndpointsNode.isArray()) {
            throw new RuntimeException("ShareFetchResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.nodeEndpoints = _collection = new ShareFetchResponseData.NodeEndpointCollection(_nodeEndpointsNode.size());
        for (JsonNode _element : _nodeEndpointsNode) {
            _collection.add(NodeEndpointJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ShareFetchResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        if (_object.errorMessage == null) {
            _node.set("errorMessage", (JsonNode)NullNode.instance);
        } else {
            _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
        }
        _node.set("acquisitionLockTimeoutMs", (JsonNode)new IntNode(_object.acquisitionLockTimeoutMs));
        ArrayNode _responsesArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareFetchResponseData.ShareFetchableTopicResponse _element : _object.responses) {
            _responsesArray.add(ShareFetchableTopicResponseJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("responses", (JsonNode)_responsesArray);
        ArrayNode _nodeEndpointsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareFetchResponseData.NodeEndpoint _element : _object.nodeEndpoints) {
            _nodeEndpointsArray.add(NodeEndpointJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("nodeEndpoints", (JsonNode)_nodeEndpointsArray);
        return _node;
    }

    public static JsonNode write(ShareFetchResponseData _object, short _version) {
        return ShareFetchResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class ShareFetchableTopicResponseJsonConverter {
        public static ShareFetchResponseData.ShareFetchableTopicResponse read(JsonNode _node, short _version) {
            ShareFetchResponseData.ShareFetchableTopicResponse _object = new ShareFetchResponseData.ShareFetchableTopicResponse();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("ShareFetchableTopicResponse: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("ShareFetchableTopicResponse expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ShareFetchableTopicResponse: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ShareFetchableTopicResponse expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ShareFetchResponseData.PartitionData> _collection = new ArrayList<ShareFetchResponseData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareFetchResponseData.ShareFetchableTopicResponse _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareFetchResponseData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ShareFetchResponseData.ShareFetchableTopicResponse _object, short _version) {
            return ShareFetchableTopicResponseJsonConverter.write(_object, _version, true);
        }
    }

    public static class NodeEndpointJsonConverter {
        public static ShareFetchResponseData.NodeEndpoint read(JsonNode _node, short _version) {
            ShareFetchResponseData.NodeEndpoint _object = new ShareFetchResponseData.NodeEndpoint();
            JsonNode _nodeIdNode = _node.get("nodeId");
            if (_nodeIdNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'nodeId', which is mandatory in version " + _version);
            }
            _object.nodeId = MessageUtil.jsonNodeToInt(_nodeIdNode, "NodeEndpoint");
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("NodeEndpoint expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.host = _hostNode.asText();
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToInt(_portNode, "NodeEndpoint");
            JsonNode _rackNode = _node.get("rack");
            if (_rackNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'rack', which is mandatory in version " + _version);
            }
            if (_rackNode.isNull()) {
                _object.rack = null;
            } else {
                if (!_rackNode.isTextual()) {
                    throw new RuntimeException("NodeEndpoint expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.rack = _rackNode.asText();
            }
            return _object;
        }

        public static JsonNode write(ShareFetchResponseData.NodeEndpoint _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("nodeId", (JsonNode)new IntNode(_object.nodeId));
            _node.set("host", (JsonNode)new TextNode(_object.host));
            _node.set("port", (JsonNode)new IntNode(_object.port));
            if (_object.rack == null) {
                _node.set("rack", (JsonNode)NullNode.instance);
            } else {
                _node.set("rack", (JsonNode)new TextNode(_object.rack));
            }
            return _node;
        }

        public static JsonNode write(ShareFetchResponseData.NodeEndpoint _object, short _version) {
            return NodeEndpointJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static ShareFetchResponseData.PartitionData read(JsonNode _node, short _version) {
            ShareFetchResponseData.PartitionData _object = new ShareFetchResponseData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "PartitionData");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("PartitionData expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _acknowledgeErrorCodeNode = _node.get("acknowledgeErrorCode");
            if (_acknowledgeErrorCodeNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'acknowledgeErrorCode', which is mandatory in version " + _version);
            }
            _object.acknowledgeErrorCode = MessageUtil.jsonNodeToShort(_acknowledgeErrorCodeNode, "PartitionData");
            JsonNode _acknowledgeErrorMessageNode = _node.get("acknowledgeErrorMessage");
            if (_acknowledgeErrorMessageNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'acknowledgeErrorMessage', which is mandatory in version " + _version);
            }
            if (_acknowledgeErrorMessageNode.isNull()) {
                _object.acknowledgeErrorMessage = null;
            } else {
                if (!_acknowledgeErrorMessageNode.isTextual()) {
                    throw new RuntimeException("PartitionData expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.acknowledgeErrorMessage = _acknowledgeErrorMessageNode.asText();
            }
            JsonNode _currentLeaderNode = _node.get("currentLeader");
            if (_currentLeaderNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'currentLeader', which is mandatory in version " + _version);
            }
            _object.currentLeader = LeaderIdAndEpochJsonConverter.read(_currentLeaderNode, _version);
            JsonNode _recordsNode = _node.get("records");
            if (_recordsNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'records', which is mandatory in version " + _version);
            }
            _object.records = MemoryRecords.readableRecords(ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(_recordsNode, "PartitionData")));
            JsonNode _acquiredRecordsNode = _node.get("acquiredRecords");
            if (_acquiredRecordsNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'acquiredRecords', which is mandatory in version " + _version);
            }
            if (!_acquiredRecordsNode.isArray()) {
                throw new RuntimeException("PartitionData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ShareFetchResponseData.AcquiredRecords> _collection = new ArrayList<ShareFetchResponseData.AcquiredRecords>(_acquiredRecordsNode.size());
            _object.acquiredRecords = _collection;
            for (JsonNode _element : _acquiredRecordsNode) {
                _collection.add(AcquiredRecordsJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareFetchResponseData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            _node.set("acknowledgeErrorCode", (JsonNode)new ShortNode(_object.acknowledgeErrorCode));
            if (_object.acknowledgeErrorMessage == null) {
                _node.set("acknowledgeErrorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("acknowledgeErrorMessage", (JsonNode)new TextNode(_object.acknowledgeErrorMessage));
            }
            _node.set("currentLeader", LeaderIdAndEpochJsonConverter.write(_object.currentLeader, _version, _serializeRecords));
            if (_serializeRecords) {
                _node.set("records", (JsonNode)new BinaryNode(new byte[0]));
            } else {
                _node.set("recordsSizeInBytes", (JsonNode)new IntNode(_object.records.sizeInBytes()));
            }
            ArrayNode _acquiredRecordsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareFetchResponseData.AcquiredRecords _element : _object.acquiredRecords) {
                _acquiredRecordsArray.add(AcquiredRecordsJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("acquiredRecords", (JsonNode)_acquiredRecordsArray);
            return _node;
        }

        public static JsonNode write(ShareFetchResponseData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class LeaderIdAndEpochJsonConverter {
        public static ShareFetchResponseData.LeaderIdAndEpoch read(JsonNode _node, short _version) {
            ShareFetchResponseData.LeaderIdAndEpoch _object = new ShareFetchResponseData.LeaderIdAndEpoch();
            JsonNode _leaderIdNode = _node.get("leaderId");
            if (_leaderIdNode == null) {
                throw new RuntimeException("LeaderIdAndEpoch: unable to locate field 'leaderId', which is mandatory in version " + _version);
            }
            _object.leaderId = MessageUtil.jsonNodeToInt(_leaderIdNode, "LeaderIdAndEpoch");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("LeaderIdAndEpoch: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "LeaderIdAndEpoch");
            return _object;
        }

        public static JsonNode write(ShareFetchResponseData.LeaderIdAndEpoch _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("leaderId", (JsonNode)new IntNode(_object.leaderId));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            return _node;
        }

        public static JsonNode write(ShareFetchResponseData.LeaderIdAndEpoch _object, short _version) {
            return LeaderIdAndEpochJsonConverter.write(_object, _version, true);
        }
    }

    public static class AcquiredRecordsJsonConverter {
        public static ShareFetchResponseData.AcquiredRecords read(JsonNode _node, short _version) {
            ShareFetchResponseData.AcquiredRecords _object = new ShareFetchResponseData.AcquiredRecords();
            JsonNode _firstOffsetNode = _node.get("firstOffset");
            if (_firstOffsetNode == null) {
                throw new RuntimeException("AcquiredRecords: unable to locate field 'firstOffset', which is mandatory in version " + _version);
            }
            _object.firstOffset = MessageUtil.jsonNodeToLong(_firstOffsetNode, "AcquiredRecords");
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("AcquiredRecords: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            }
            _object.lastOffset = MessageUtil.jsonNodeToLong(_lastOffsetNode, "AcquiredRecords");
            JsonNode _deliveryCountNode = _node.get("deliveryCount");
            if (_deliveryCountNode == null) {
                throw new RuntimeException("AcquiredRecords: unable to locate field 'deliveryCount', which is mandatory in version " + _version);
            }
            _object.deliveryCount = MessageUtil.jsonNodeToShort(_deliveryCountNode, "AcquiredRecords");
            return _object;
        }

        public static JsonNode write(ShareFetchResponseData.AcquiredRecords _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("firstOffset", (JsonNode)new LongNode(_object.firstOffset));
            _node.set("lastOffset", (JsonNode)new LongNode(_object.lastOffset));
            _node.set("deliveryCount", (JsonNode)new ShortNode(_object.deliveryCount));
            return _node;
        }

        public static JsonNode write(ShareFetchResponseData.AcquiredRecords _object, short _version) {
            return AcquiredRecordsJsonConverter.write(_object, _version, true);
        }
    }
}

